/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.api;

import android.view.InputEvent;
import com.unity3d.services.ads.api.AdUnit;
import com.unity3d.services.ads.measurements.MeasurementsErrors;
import com.unity3d.services.ads.measurements.MeasurementsService;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;

public class Measurements {
    private static final MeasurementsService measurementsService = (MeasurementsService)Utilities.getService(MeasurementsService.class);

    @WebViewExposed
    public static void checkAvailability(WebViewCallback callback) {
        measurementsService.checkAvailability();
        callback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void registerView(String url, WebViewCallback callback) {
        measurementsService.registerView(url);
        callback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void registerClick(String url, WebViewCallback callback) {
        if (AdUnit.getAdUnitActivity() == null) {
            callback.error(MeasurementsErrors.ERROR_AD_UNIT_NULL, new Object[0]);
            return;
        }
        if (AdUnit.getAdUnitActivity().getLayout() == null) {
            callback.error(MeasurementsErrors.ERROR_LAYOUT_NULL, new Object[0]);
            return;
        }
        InputEvent lastInputEvent = AdUnit.getAdUnitActivity().getLayout().getLastInputEvent();
        if (lastInputEvent == null) {
            callback.error(MeasurementsErrors.ERROR_LAST_INPUT_EVENT_NULL, new Object[0]);
            return;
        }
        measurementsService.registerClick(url, lastInputEvent);
        callback.invoke(new Object[0]);
    }
}

