/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.core.domain;

import android.opengl.GLES20;
import com.google.protobuf.ByteString;
import com.unity3d.ads.core.data.repository.SessionRepository;
import com.unity3d.ads.core.domain.GetOpenGLRendererInfo;
import com.unity3d.ads.gl.EglCore;
import com.unity3d.ads.gl.OffscreenSurface;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.koin.core.annotation.Single;

@Single
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0006H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/unity3d/ads/core/domain/GetAndroidOpenGLRendererInfo;", "Lcom/unity3d/ads/core/domain/GetOpenGLRendererInfo;", "sessionRepository", "Lcom/unity3d/ads/core/data/repository/SessionRepository;", "(Lcom/unity3d/ads/core/data/repository/SessionRepository;)V", "invoke", "Lcom/google/protobuf/ByteString;", "unity-ads_release"})
public final class GetAndroidOpenGLRendererInfo
implements GetOpenGLRendererInfo {
    @NotNull
    private final SessionRepository sessionRepository;

    public GetAndroidOpenGLRendererInfo(@NotNull SessionRepository sessionRepository) {
        Intrinsics.checkNotNullParameter((Object)sessionRepository, (String)"sessionRepository");
        this.sessionRepository = sessionRepository;
    }

    @Override
    @NotNull
    public ByteString invoke() {
        ByteString byteString;
        boolean openglGpuEnabled = this.sessionRepository.getFeatureFlags().getOpenglGpuEnabled();
        if (openglGpuEnabled) {
            EglCore eglCore = new EglCore(null, 2);
            OffscreenSurface surface = new OffscreenSurface(eglCore, 1, 1);
            surface.makeCurrent();
            String renderer = GLES20.glGetString((int)7937);
            Intrinsics.checkNotNullExpressionValue((Object)renderer, (String)"renderer");
            byte[] byArray = renderer.getBytes(Charsets.ISO_8859_1);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            ByteString rendererByteString = ByteString.copyFrom((byte[])byArray);
            surface.release();
            eglCore.release();
            ByteString byteString2 = rendererByteString;
            Intrinsics.checkNotNullExpressionValue((Object)byteString2, (String)"{\n            // We need\u2026dererByteString\n        }");
            byteString = byteString2;
        } else {
            ByteString byteString3 = ByteString.empty();
            byteString = byteString3;
            Intrinsics.checkNotNullExpressionValue((Object)byteString3, (String)"{\n            ByteString.empty()\n        }");
        }
        return byteString;
    }
}

