package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.gatewayclient.RequestPolicy
import com.unity3d.services.core.di.ServiceProvider.NAMED_AD_REQ
import org.koin.core.annotation.Named
import org.koin.core.annotation.Single

@Single
@Named(NAMED_AD_REQ)
internal class GetAdRequestPolicy(private val sessionRepository: SessionRepository): GetRequestPolicy {
    override fun invoke(): RequestPolicy {
        return RequestPolicy(
            maxDuration = sessionRepository.nativeConfiguration.adPolicy.retryPolicy.maxDuration,
            retryMaxInterval = sessionRepository.nativeConfiguration.adPolicy.retryPolicy.retryMaxInterval,
            retryWaitBase = sessionRepository.nativeConfiguration.adPolicy.retryPolicy.retryWaitBase,
            retryJitterPct = sessionRepository.nativeConfiguration.adPolicy.retryPolicy.retryJitterPct,
            connectTimeout = sessionRepository.nativeConfiguration.adPolicy.timeoutPolicy.connectTimeoutMs,
            readTimeout = sessionRepository.nativeConfiguration.adPolicy.timeoutPolicy.readTimeoutMs,
            writeTimeout = sessionRepository.nativeConfiguration.adPolicy.timeoutPolicy.writeTimeoutMs,
            shouldStoreLocally = sessionRepository.nativeConfiguration.adPolicy.retryPolicy.shouldStoreLocally
        )
    }
}