package com.unity3d.ads.core.domain

import com.unity3d.ads.adplayer.*
import com.unity3d.services.core.di.ServiceProvider.DEFAULT_DISPATCHER
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import org.koin.core.annotation.Named
import org.koin.core.annotation.Single

@Single
internal class GetCommonWebViewBridgeUseCase(
    @Named(DEFAULT_DISPATCHER) private val dispatcher: CoroutineDispatcher = Dispatchers.Default,
) : GetWebViewBridgeUseCase {
    override fun invoke(webViewContainer: AndroidWebViewContainer, adPlayerScope: CoroutineScope): WebViewBridge {
        return CommonWebViewBridge(
            webViewContainer = webViewContainer,
            dispatcher = dispatcher,
            adPlayerScope = adPlayerScope,
        )
    }
}