package com.unity3d.ads.core.data.model

import androidx.datastore.core.CorruptionException
import androidx.datastore.core.Serializer
import com.google.protobuf.InvalidProtocolBufferException
import java.io.InputStream
import java.io.OutputStream
import UniversalRequestStoreOuterClass.UniversalRequestStore

class UniversalRequestStoreSerializer : Serializer<UniversalRequestStore> {

    override val defaultValue: UniversalRequestStore = UniversalRequestStore.getDefaultInstance()

    override suspend fun readFrom(input: InputStream): UniversalRequestStore {
        try {
            return UniversalRequestStore.parseFrom(input)
        } catch (exception: InvalidProtocolBufferException) {
            throw CorruptionException("Cannot read proto.", exception)
        }
    }

    override suspend fun writeTo(t: UniversalRequestStore, output: OutputStream) = t.writeTo(output)
}