package com.unity3d.services.core.di

import org.koin.core.qualifier.named

/**
 * Base interface to extend to facilitate access to [ServiceProvider]
 */
interface IServiceComponent

/**
 * Get instance from the ServiceProvider
 * @param named if a specific instance is required
 *
 * @return instance of type T
 */
inline fun <reified T : Any> IServiceComponent.get(
    named: String = ""
): T = KoinModule.system.koin.get(named(named))

/**
 * Lazy inject instance from the ServiceProvider
 * @param named if a specific instance is required
 * @param mode to define a specific [LazyThreadSafetyMode]
 *
 * @return [Lazy] instance of type T
 */
inline fun <reified T : Any> IServiceComponent.inject(
    named: String = "",
    mode: LazyThreadSafetyMode = LazyThreadSafetyMode.NONE,
): Lazy<T> = KoinModule.system.koin.inject(named(named), mode)