package com.unity3d.ads.core.domain

import android.content.Context
import com.google.protobuf.ByteString
import com.unity3d.ads.UnityAdsLoadOptions
import com.unity3d.ads.core.data.model.LoadResult
import gateway.v1.AdRequestOuterClass.BannerSize
import headerbidding.v1.HeaderBiddingAdMarkupOuterClass.HeaderBiddingAdMarkup

interface Load {
    suspend operator fun invoke(
        context: Context,
        placement: String,
        opportunityId: ByteString,
        headerBiddingAdMarkup: HeaderBiddingAdMarkup,
        bannerSize: BannerSize? = null,
        loadOptions: UnityAdsLoadOptions
    ) : LoadResult
}