package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.gatewayclient.RequestPolicy
import com.unity3d.services.core.di.ServiceProvider.NAMED_OPERATIVE_REQ
import org.koin.core.annotation.Named
import org.koin.core.annotation.Single

@Single
@Named(NAMED_OPERATIVE_REQ)
internal class GetOperativeEventRequestPolicy(private val sessionRepository: SessionRepository): GetRequestPolicy {
    override fun invoke(): RequestPolicy {
        return RequestPolicy(
            maxDuration = sessionRepository.nativeConfiguration.operativeEventPolicy.retryPolicy.maxDuration,
            retryMaxInterval = sessionRepository.nativeConfiguration.operativeEventPolicy.retryPolicy.retryMaxInterval,
            retryWaitBase = sessionRepository.nativeConfiguration.operativeEventPolicy.retryPolicy.retryWaitBase,
            retryJitterPct = sessionRepository.nativeConfiguration.operativeEventPolicy.retryPolicy.retryJitterPct,
            connectTimeout = sessionRepository.nativeConfiguration.operativeEventPolicy.timeoutPolicy.connectTimeoutMs,
            readTimeout = sessionRepository.nativeConfiguration.operativeEventPolicy.timeoutPolicy.readTimeoutMs,
            writeTimeout = sessionRepository.nativeConfiguration.operativeEventPolicy.timeoutPolicy.writeTimeoutMs,
            shouldStoreLocally = sessionRepository.nativeConfiguration.operativeEventPolicy.retryPolicy.shouldStoreLocally
        )
    }
}