package com.unity3d.ads.core.domain

import com.google.protobuf.ByteString
import gateway.v1.UniversalRequestKt.payload
import gateway.v1.UniversalRequestOuterClass.UniversalRequest
import gateway.v1.adPlayerConfigRequest
import org.koin.core.annotation.Single

@Single
internal class GetAndroidAdPlayerConfigRequest(
    private val getUniversalRequestForPayLoad: GetUniversalRequestForPayLoad,
) : GetAdPlayerConfigRequest {
    override suspend fun invoke(placement: String, opportunityId: ByteString, configToken: ByteString): UniversalRequest {
        val request = adPlayerConfigRequest {
            configurationToken = configToken
            placementId = placement
            // webviewVersion
            impressionOpportunityId = opportunityId
        }
        val payload = payload {
            adPlayerConfigRequest = request
        }
        return getUniversalRequestForPayLoad(payload)
    }
}