package com.unity3d.ads.core.data.model

import androidx.datastore.core.CorruptionException
import androidx.datastore.core.Serializer
import com.google.protobuf.InvalidProtocolBufferException
import java.io.InputStream
import java.io.OutputStream
import ByteStringStoreOuterClass.ByteStringStore

class ByteStringSerializer : Serializer<ByteStringStore> {

    override val defaultValue: ByteStringStore = ByteStringStore.getDefaultInstance()

    override suspend fun readFrom(input: InputStream): ByteStringStore {
        try {
            return ByteStringStore.parseFrom(input)
        } catch (exception: InvalidProtocolBufferException) {
            throw CorruptionException("Cannot read proto.", exception)
        }
    }

    override suspend fun writeTo(t: ByteStringStore, output: OutputStream) = t.writeTo(output)
}