package com.unity3d.ads.core.data.datasource

import androidx.datastore.core.CorruptionException
import androidx.datastore.core.DataStore
import com.unity3d.services.core.di.ServiceProvider.DATA_STORE_WEBVIEW_CONFIG
import kotlinx.coroutines.flow.catch
import kotlinx.coroutines.flow.first
import org.koin.core.annotation.Named
import org.koin.core.annotation.Single

@Single
class WebviewConfigurationDataSource(
    @Named(DATA_STORE_WEBVIEW_CONFIG) private val webviewConfigurationStore: DataStore<WebviewConfigurationStore.WebViewConfigurationStore>
) {
    suspend fun get(): WebviewConfigurationStore.WebViewConfigurationStore =
        webviewConfigurationStore.data.catch { exception ->
            if (exception is CorruptionException) {
                emit(WebviewConfigurationStore.WebViewConfigurationStore.getDefaultInstance())
            } else {
                throw exception
            }
        }.first()

    suspend fun set(data: WebviewConfigurationStore.WebViewConfigurationStore) {
        webviewConfigurationStore.updateData { data }
    }
}