package com.unity3d.services.ads.gmascar.managers;

public enum ScarBiddingManagerType {
	DISABLED(Constants.DIS),
	EAGER(Constants.EAG);

	private final String name;

	ScarBiddingManagerType(final String name) {
		this.name = name;
	}

	public String getName() {
		return this.name;
	}

	public static ScarBiddingManagerType fromName(final String name) {
		switch(name) {
			case Constants.EAG:
				return EAGER;
			case Constants.DIS:
			default:
				return DISABLED;
		}
	}

	private static class Constants {
		private static final String EAG = "eag";
		private static final String DIS = "dis";
	}
}
