package com.unity3d.ads.adplayer

import android.content.Context
import android.webkit.WebResourceResponse
import androidx.webkit.WebViewAssetLoader
import androidx.webkit.WebViewAssetLoader.Builder
import com.unity3d.services.UnityAdsConstants
import com.unity3d.services.core.log.DeviceLog
import org.koin.core.annotation.Single
import java.net.URLConnection

fun interface GetWebViewCacheAssetLoader : () -> WebViewAssetLoader

@Single
fun provideGetWebViewCacheAssetLoader(context: Context) = GetWebViewCacheAssetLoader {
    Builder()
        .addPathHandler(UnityAdsConstants.DefaultUrls.WEBVIEW_ASSET_PATH) { path: String ->
            try {
                val inputStream = context.assets.open(path)
                WebResourceResponse(guessMimeType(path), null, inputStream)
            } catch (e: Exception) {
                DeviceLog.debug("Webview Asset not found: %s", path)
                null
            }
        }
        .setDomain(UnityAdsConstants.DefaultUrls.WEBVIEW_DOMAIN)
        .build()
}

fun guessMimeType(filePath: String): String = URLConnection.guessContentTypeFromName(filePath)
