package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.model.OperationType
import com.unity3d.ads.gatewayclient.GatewayClient
import gateway.v1.PrivacyUpdateRequestOuterClass.PrivacyUpdateRequest
import gateway.v1.PrivacyUpdateResponseOuterClass.PrivacyUpdateResponse

class SendPrivacyUpdateRequest(
    private val getPrivacyUpdateRequest: GetPrivacyUpdateRequest,
    private val getRequestPolicy: GetRequestPolicy,
    private val gatewayClient: GatewayClient,
) {
    suspend operator fun invoke(privacyUpdateRequest: PrivacyUpdateRequest = PrivacyUpdateRequest.getDefaultInstance()): PrivacyUpdateResponse {
        val universalPrivacyUpdateRequest = getPrivacyUpdateRequest(privacyUpdateRequest)
        val requestPolicy = getRequestPolicy()
        val response = gatewayClient.request(request = universalPrivacyUpdateRequest, requestPolicy = requestPolicy, operationType = OperationType.PRIVACY_UPDATE)
        return response.payload.privacyUpdateResponse
    }
}