package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import gateway.v1.UniversalRequestKt.payload
import gateway.v1.UniversalRequestOuterClass.UniversalRequest
import gateway.v1.initializationCompletedEventRequest

internal class GetAndroidInitializationCompletedRequest(
    private val getUniversalRequestForPayLoad: GetUniversalRequestForPayLoad,
    private val deviceInfoRepository: DeviceInfoRepository
) : GetInitializationCompletedRequest {
    override suspend fun invoke(): UniversalRequest {
        val request = initializationCompletedEventRequest {
            staticDeviceInfo = deviceInfoRepository.staticDeviceInfo()
            dynamicDeviceInfo = deviceInfoRepository.dynamicDeviceInfo
        }

        val initCompletedPayload = payload {
            initializationCompletedEventRequest = request
        }

        return getUniversalRequestForPayLoad(initCompletedPayload)
    }
}