package com.unity3d.ads.core.data.manager

import android.content.Context
import android.webkit.WebView
import com.iab.omid.library.unity3d.Omid
import com.iab.omid.library.unity3d.adsession.AdEvents
import com.iab.omid.library.unity3d.adsession.AdSession
import com.iab.omid.library.unity3d.adsession.AdSessionConfiguration
import com.iab.omid.library.unity3d.adsession.AdSessionContext
import com.iab.omid.library.unity3d.adsession.CreativeType
import com.iab.omid.library.unity3d.adsession.ImpressionType
import com.iab.omid.library.unity3d.adsession.Owner
import com.iab.omid.library.unity3d.adsession.Partner

class AndroidOmidManager : OmidManager {
    override val isActive: Boolean
        get() = Omid.isActive()
    override val version: String
        get() = Omid.getVersion()

    override fun activate(context: Context) = Omid.activate(context)

    override fun createHtmlAdSessionContext(
        partner: Partner?,
        adView: WebView?,
        contentUrl: String?,
        customReferenceData: String?
    ): AdSessionContext = AdSessionContext.createHtmlAdSessionContext(
        partner,
        adView,
        contentUrl,
        customReferenceData
    )

    override fun createAdSessionConfiguration(
        creativeType: CreativeType,
        impressionType: ImpressionType,
        owner: Owner,
        mediaEventsOwner: Owner,
        isolateVerificationScripts: Boolean
    ): AdSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration(
        creativeType,
        impressionType,
        owner,
        mediaEventsOwner,
        isolateVerificationScripts
    )

    override fun createAdSession(
        adSessionConfiguration: AdSessionConfiguration,
        context: AdSessionContext
    ): AdSession = AdSession.createAdSession(adSessionConfiguration, context)

    override fun createAdEvents(adSession: AdSession): AdEvents = AdEvents.createAdEvents(adSession)
}