/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.core.configuration.IInitializationListener;
import com.unity3d.services.core.configuration.IInitializeEventsMetricSender;
import com.unity3d.services.core.configuration.InitializationNotificationCenter;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.request.metrics.Metric;
import com.unity3d.services.core.request.metrics.SDKMetrics;
import com.unity3d.services.core.request.metrics.TSIMetric;
import java.util.HashMap;
import java.util.Map;

public class InitializeEventsMetricSender
implements IInitializeEventsMetricSender,
IInitializationListener {
    private static InitializeEventsMetricSender _instance;
    private Map<String, String> _metricTags;
    private long _startTime = 0L;
    private long _configStartTime = 0L;
    private boolean _initMetricSent = false;
    private boolean _tokenMetricSent = false;

    public static IInitializeEventsMetricSender getInstance() {
        if (_instance == null) {
            _instance = new InitializeEventsMetricSender();
        }
        return _instance;
    }

    private InitializeEventsMetricSender() {
        InitializationNotificationCenter.getInstance().addListener(this);
    }

    @Override
    public void didInitStart() {
        this._startTime = System.currentTimeMillis();
        this.sendMetric(TSIMetric.newInitStarted(this.getMetricTags()));
    }

    @Override
    public void didConfigRequestStart() {
        this._configStartTime = System.currentTimeMillis();
    }

    @Override
    public synchronized void sdkDidInitialize() {
        if (this._startTime == 0L) {
            DeviceLog.debug("sdkDidInitialize called before didInitStart, skipping metric");
            return;
        }
        if (!this._initMetricSent) {
            this.sendMetric(TSIMetric.newInitTimeSuccess(this.duration(), this.getMetricTags()));
            this._initMetricSent = true;
        }
    }

    @Override
    public Long initializationStartTimeStamp() {
        return this._startTime;
    }

    @Override
    public synchronized void sdkInitializeFailed(String message) {
        if (this._startTime == 0L) {
            DeviceLog.debug("sdkInitializeFailed called before didInitStart, skipping metric");
            return;
        }
        if (!this._initMetricSent) {
            this.sendMetric(TSIMetric.newInitTimeFailure(this.duration(), this.getMetricTags()));
            this._initMetricSent = true;
        }
    }

    @Override
    public synchronized void sdkTokenDidBecomeAvailableWithConfig(boolean withConfig) {
        if (!this._tokenMetricSent) {
            this.sendTokenAvailabilityMetricWithConfig(withConfig);
            if (withConfig) {
                this.sendTokenResolutionRequestMetricIfNeeded();
            }
            this._tokenMetricSent = true;
        }
    }

    private void sendTokenAvailabilityMetricWithConfig(boolean withConfig) {
        if (this._startTime == 0L) {
            DeviceLog.debug("sendTokenAvailabilityMetricWithConfig called before didInitStart, skipping metric");
            return;
        }
        Long duration = System.currentTimeMillis() - this._startTime;
        Map<String, String> tags = this.getMetricTags();
        Metric metric = withConfig ? TSIMetric.newTokenAvailabilityLatencyConfig(duration, tags) : TSIMetric.newTokenAvailabilityLatencyWebview(duration, tags);
        this.sendMetric(metric);
    }

    private void sendTokenResolutionRequestMetricIfNeeded() {
        if (this._configStartTime == 0L) {
            DeviceLog.debug("sendTokenResolutionRequestMetricIfNeeded called before didInitStart, skipping metric");
            return;
        }
        this.sendMetric(TSIMetric.newTokenResolutionRequestLatency(this.tokenDuration(), this.getMetricTags()));
    }

    @Override
    public Long duration() {
        return System.currentTimeMillis() - this._startTime;
    }

    @Override
    public Long tokenDuration() {
        return System.currentTimeMillis() - this._configStartTime;
    }

    @Override
    public void setMetricTags(Map<String, String> metricTags) {
        this._metricTags = metricTags;
    }

    @Override
    public Map<String, String> getMetricTags() {
        if (this._metricTags != null) {
            return this._metricTags;
        }
        return new HashMap<String, String>();
    }

    @Override
    public void sendMetric(Metric metric) {
        SDKMetrics.getInstance().sendMetric(metric);
    }

    @Override
    public void onSdkInitialized() {
        this.sdkDidInitialize();
    }

    @Override
    public void onSdkInitializationFailed(String message, int code) {
        this.sdkInitializeFailed(message);
    }
}

