/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.Experiments;
import com.unity3d.services.core.device.reader.DeviceInfoReaderCompressor;
import com.unity3d.services.core.device.reader.DeviceInfoReaderCompressorWithMetrics;
import com.unity3d.services.core.device.reader.DeviceInfoReaderUrlEncoder;
import com.unity3d.services.core.device.reader.IDeviceInfoReader;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.WebRequest;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ConfigurationRequestFactory {
    private final String _configUrl;
    private final Configuration _configuration;
    private final IDeviceInfoReader _deviceInfoReader;

    public ConfigurationRequestFactory(Configuration configuration, IDeviceInfoReader deviceInfoReader, String configUrl) {
        this._configuration = configuration;
        this._deviceInfoReader = deviceInfoReader;
        this._configUrl = configUrl;
    }

    public WebRequest getWebRequest() throws MalformedURLException {
        WebRequest webRequest;
        String url = this._configUrl + this.buildQueryString();
        DeviceLog.debug("Requesting configuration with: " + url);
        Experiments experiments = this._configuration.getExperiments();
        if (experiments != null && experiments.isTwoStageInitializationEnabled() && experiments.isPOSTMethodInConfigRequestEnabled()) {
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            headers.put("Content-Encoding", Collections.singletonList("gzip"));
            webRequest = new WebRequest(url, "POST", headers);
            DeviceInfoReaderCompressorWithMetrics infoReaderCompressor = new DeviceInfoReaderCompressorWithMetrics(new DeviceInfoReaderCompressor(this._deviceInfoReader), experiments);
            byte[] queryData = infoReaderCompressor.getDeviceData();
            webRequest.setBody(queryData);
        } else {
            webRequest = new WebRequest(url, "GET");
        }
        return webRequest;
    }

    private String buildQueryString() {
        StringBuilder queryString = new StringBuilder();
        queryString.append("?");
        Experiments experiments = this._configuration.getExperiments();
        if (experiments != null && experiments.isTwoStageInitializationEnabled()) {
            queryString.append(this.buildCompressedQueryStringIfNeeded());
        } else {
            queryString.append("ts=").append(System.currentTimeMillis());
            queryString.append("&sdkVersion=").append(SdkProperties.getVersionCode());
            queryString.append("&sdkVersionName=").append(SdkProperties.getVersionName());
            queryString.append("&gameId=").append(ClientProperties.getGameId());
        }
        return queryString.toString();
    }

    private String buildCompressedQueryStringIfNeeded() {
        String compressedQueryString = "";
        Experiments experiments = this._configuration.getExperiments();
        if (experiments != null && experiments.isTwoStageInitializationEnabled() && !experiments.isPOSTMethodInConfigRequestEnabled()) {
            String queryData = new DeviceInfoReaderUrlEncoder(new DeviceInfoReaderCompressorWithMetrics(new DeviceInfoReaderCompressor(this._deviceInfoReader), experiments)).getUrlEncodedData();
            compressedQueryString = "c=" + queryData;
        }
        return compressedQueryString;
    }
}

