/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.token;

import android.text.TextUtils;
import com.unity3d.services.ads.token.AsyncTokenStorage;
import com.unity3d.services.ads.token.TokenEvent;
import com.unity3d.services.core.configuration.InitializeEventsMetricSender;
import com.unity3d.services.core.device.TokenType;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONArray;
import org.json.JSONException;

public class TokenStorage {
    private static ConcurrentLinkedQueue<String> _queue;
    private static int _accessCounter;
    private static boolean _peekMode;
    private static String _initToken;

    public static synchronized void createTokens(JSONArray tokens) throws JSONException {
        _queue = new ConcurrentLinkedQueue();
        _accessCounter = 0;
        for (int i = 0; i < tokens.length(); ++i) {
            _queue.add(tokens.getString(i));
        }
        if (!_queue.isEmpty()) {
            TokenStorage.triggerTokenAvailable();
            AsyncTokenStorage.getInstance().onTokenAvailable(TokenType.TOKEN_REMOTE);
        }
    }

    public static synchronized void appendTokens(JSONArray tokens) throws JSONException {
        if (_queue == null) {
            _queue = new ConcurrentLinkedQueue();
            _accessCounter = 0;
        }
        for (int i = 0; i < tokens.length(); ++i) {
            _queue.add(tokens.getString(i));
        }
        if (!_queue.isEmpty()) {
            TokenStorage.triggerTokenAvailable();
            AsyncTokenStorage.getInstance().onTokenAvailable(TokenType.TOKEN_REMOTE);
        }
    }

    public static synchronized void deleteTokens() {
        _queue = null;
        _accessCounter = 0;
    }

    public static synchronized String getToken() {
        if (_queue == null) {
            return _initToken;
        }
        if (_queue.isEmpty()) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.QUEUE_EMPTY, new Object[0]);
            return null;
        }
        if (_peekMode) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.TOKEN_ACCESS, _accessCounter++);
            return _queue.peek();
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.TOKEN_ACCESS, _accessCounter++);
        return _queue.poll();
    }

    public static synchronized void setPeekMode(boolean mode) {
        _peekMode = mode;
    }

    public static synchronized void setInitToken(String value) {
        _initToken = value;
        if (_initToken != null) {
            AsyncTokenStorage.getInstance().onTokenAvailable(TokenType.TOKEN_REMOTE);
            TokenStorage.triggerTokenAvailable();
        }
    }

    private static void triggerTokenAvailable() {
        if (!TextUtils.isEmpty((CharSequence)_initToken)) {
            InitializeEventsMetricSender.getInstance().sdkTokenDidBecomeAvailableWithConfig(true);
        } else if (_queue != null && _queue.size() > 0) {
            InitializeEventsMetricSender.getInstance().sdkTokenDidBecomeAvailableWithConfig(false);
        }
    }

    static {
        _accessCounter = 0;
        _peekMode = false;
        _initToken = null;
    }
}

