/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store.gpbl.bridges;

import android.content.Context;
import com.unity3d.services.core.reflection.GenericBridge;
import com.unity3d.services.store.gpbl.BillingResultResponseCode;
import com.unity3d.services.store.gpbl.bridges.BillingResultBridge;
import com.unity3d.services.store.gpbl.bridges.SkuDetailsParamsBridge;
import com.unity3d.services.store.gpbl.proxies.BillingClientStateListenerProxy;
import com.unity3d.services.store.gpbl.proxies.PurchaseHistoryResponseListenerProxy;
import com.unity3d.services.store.gpbl.proxies.PurchaseUpdatedListenerProxy;
import com.unity3d.services.store.gpbl.proxies.PurchasesResponseListenerProxy;
import com.unity3d.services.store.gpbl.proxies.SkuDetailsResponseListenerProxy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class BillingClientBridge
extends GenericBridge {
    private static final String newBuilderMethodName = "newBuilder";
    private static final String startConnectionMethodName = "startConnection";
    private static final String endConnectionMethodName = "endConnection";
    private static final String querySkuDetailsAsyncMethodName = "querySkuDetailsAsync";
    private static final String queryPurchaseHistoryAsyncMethodName = "queryPurchaseHistoryAsync";
    private static final String queryPurchasesAsyncMethodName = "queryPurchasesAsync";
    private static final String isFeatureSupportedMethodName = "isFeatureSupported";
    private static final String isReadyMethodName = "isReady";
    private static final Map<String, Class<?>[]> staticMethods = new HashMap<String, Class<?>[]>(){
        {
            this.put(BillingClientBridge.newBuilderMethodName, new Class[]{Context.class});
        }
    };
    private final Object _billingClientInternalInstance;

    public BillingClientBridge(Object billingClientInternalInstance) throws ClassNotFoundException {
        super((Map<String, Class[]>)new HashMap<String, Class[]>(){
            {
                this.put(BillingClientBridge.newBuilderMethodName, new Class[]{Context.class});
                this.put(BillingClientBridge.startConnectionMethodName, new Class[]{BillingClientStateListenerProxy.getProxyListenerClass()});
                this.put(BillingClientBridge.endConnectionMethodName, new Class[0]);
                this.put(BillingClientBridge.querySkuDetailsAsyncMethodName, new Class[]{SkuDetailsParamsBridge.getClassForBridge(), SkuDetailsResponseListenerProxy.getProxyListenerClass()});
                this.put(BillingClientBridge.queryPurchaseHistoryAsyncMethodName, new Class[]{String.class, PurchaseHistoryResponseListenerProxy.getProxyListenerClass()});
                this.put(BillingClientBridge.queryPurchasesAsyncMethodName, new Class[]{String.class, PurchasesResponseListenerProxy.getProxyListenerClass()});
                this.put(BillingClientBridge.isFeatureSupportedMethodName, new Class[]{String.class});
                this.put(BillingClientBridge.isReadyMethodName, new Class[0]);
            }
        });
        this._billingClientInternalInstance = billingClientInternalInstance;
    }

    @Override
    protected String getClassName() {
        return "com.android.billingclient.api.BillingClient";
    }

    public void startConnection(BillingClientStateListenerProxy billingClientStateListenerProxy) throws ClassNotFoundException {
        this.callVoidMethod(startConnectionMethodName, this._billingClientInternalInstance, billingClientStateListenerProxy.getProxyInstance());
    }

    public void endConnection() {
        this.callVoidMethod(endConnectionMethodName, this._billingClientInternalInstance, new Object[0]);
    }

    public BillingResultResponseCode isFeatureSupported(String purchaseType) {
        Object billingResult = this.callNonVoidMethod(isFeatureSupportedMethodName, this._billingClientInternalInstance, purchaseType);
        BillingResultBridge billingResultBridge = new BillingResultBridge(billingResult);
        return billingResultBridge.getResponseCode();
    }

    public boolean isReady() {
        return (Boolean)this.callNonVoidMethod(isReadyMethodName, this._billingClientInternalInstance, new Object[0]);
    }

    public void querySkuDetailsAsync(SkuDetailsParamsBridge params, SkuDetailsResponseListenerProxy skuDetailsResponseListenerProxy) throws ClassNotFoundException {
        this.callVoidMethod(querySkuDetailsAsyncMethodName, this._billingClientInternalInstance, params.getInternalInstance(), skuDetailsResponseListenerProxy.getProxyInstance());
    }

    public void queryPurchaseHistoryAsync(String skuType, PurchaseHistoryResponseListenerProxy purchaseHistoryResponseListenerProxy) throws ClassNotFoundException {
        this.callVoidMethod(queryPurchaseHistoryAsyncMethodName, this._billingClientInternalInstance, skuType, purchaseHistoryResponseListenerProxy.getProxyInstance());
    }

    public void queryPurchasesAsync(String purchaseType, PurchasesResponseListenerProxy purchasesResponseListenerProxy) throws ClassNotFoundException {
        this.callVoidMethod(queryPurchasesAsyncMethodName, this._billingClientInternalInstance, purchaseType, purchasesResponseListenerProxy.getProxyInstance());
    }

    public static BuilderBridge newBuilder(Context context) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        Object billingClientBuilderInternalInstance = BillingClientBridge.callNonVoidStaticMethod(newBuilderMethodName, context);
        return new BuilderBridge(billingClientBuilderInternalInstance);
    }

    public static Object callNonVoidStaticMethod(String methodName, Object ... parameters) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method method = BillingClientBridge.getClassForBridge().getMethod(methodName, staticMethods.get(methodName));
        return method.invoke(null, parameters);
    }

    private static Class<?> getClassForBridge() throws ClassNotFoundException {
        return Class.forName("com.android.billingclient.api.BillingClient");
    }

    public static class BuilderBridge
    extends GenericBridge {
        private static final String setListenerMethodName = "setListener";
        private static final String enablePendingPurchasesMethodName = "enablePendingPurchases";
        private static final String buildMethodName = "build";
        private Object _billingClientBuilderInternalInstance;

        public BuilderBridge(Object billingClientBuilderInternalInstance) throws ClassNotFoundException {
            super((Map<String, Class[]>)new HashMap<String, Class[]>(){
                {
                    this.put(BuilderBridge.setListenerMethodName, new Class[]{PurchaseUpdatedListenerProxy.getProxyListenerClass()});
                    this.put(BuilderBridge.enablePendingPurchasesMethodName, new Class[0]);
                    this.put(BuilderBridge.buildMethodName, new Class[0]);
                }
            });
            this._billingClientBuilderInternalInstance = billingClientBuilderInternalInstance;
        }

        @Override
        protected String getClassName() {
            return "com.android.billingclient.api.BillingClient$Builder";
        }

        public BuilderBridge setListener(PurchaseUpdatedListenerProxy purchaseUpdatedListenerProxy) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            this._billingClientBuilderInternalInstance = this.callNonVoidMethod(setListenerMethodName, this._billingClientBuilderInternalInstance, purchaseUpdatedListenerProxy.getProxyInstance());
            return this;
        }

        public BuilderBridge enablePendingPurchases() {
            this._billingClientBuilderInternalInstance = this.callNonVoidMethod(enablePendingPurchasesMethodName, this._billingClientBuilderInternalInstance, new Object[0]);
            return this;
        }

        public BillingClientBridge build() throws ClassNotFoundException {
            Object billingClient = this.callNonVoidMethod(buildMethodName, this._billingClientBuilderInternalInstance, new Object[0]);
            return new BillingClientBridge(billingClient);
        }
    }
}

