/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.gmascar.finder;

import com.unity3d.scar.adapter.common.GMAEvent;
import com.unity3d.services.ads.gmascar.bridges.MobileAdsBridge;
import com.unity3d.services.ads.gmascar.finder.GMAInitializer;
import com.unity3d.services.ads.gmascar.finder.PresenceDetector;
import com.unity3d.services.ads.gmascar.listeners.IInitializationStatusListener;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;

public class ScarVersionFinder
implements IInitializationStatusListener {
    private static MobileAdsBridge _mobileAdsBridge;
    private PresenceDetector _presenceDetector;
    private GMAInitializer _gmaInitializer;
    private long _gmaSdkVersionCode = -1L;

    public ScarVersionFinder(MobileAdsBridge mobileAdsBridge, PresenceDetector presenceDetector, GMAInitializer gmaInitializer) {
        _mobileAdsBridge = mobileAdsBridge;
        this._presenceDetector = presenceDetector;
        this._gmaInitializer = gmaInitializer;
        this._gmaInitializer.getInitializeListenerBridge().setStatusListener(this);
    }

    public void getVersion() {
        try {
            if (!this._presenceDetector.areGMAClassesPresent()) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.INIT_GMA, (Enum)GMAEvent.VERSION, "0.0.0");
                return;
            }
            if (!this._gmaInitializer.isInitialized()) {
                this._gmaInitializer.initializeGMA();
            } else {
                this.findAndSendVersion(true);
            }
        }
        catch (Exception e) {
            DeviceLog.debug("Got exception finding GMA SDK: %s", e.getLocalizedMessage());
        }
    }

    public void findAndSendVersion(boolean initializeSuccess) {
        String version = initializeSuccess ? _mobileAdsBridge.getVersionString() : "0.0.0";
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.INIT_GMA, (Enum)GMAEvent.VERSION, version);
    }

    public long getGoogleSdkVersionCode() {
        String[] versionComponents;
        String gmaSdkVersion;
        if (this._gmaSdkVersionCode == -1L && (gmaSdkVersion = _mobileAdsBridge.getVersionString()) != null && (versionComponents = gmaSdkVersion.split("\\.")).length > 1) {
            this._gmaSdkVersionCode = Long.parseLong(versionComponents[1]);
        }
        return this._gmaSdkVersionCode;
    }

    @Override
    public void onInitializationComplete(Object initStatus) {
        boolean isInitSuccessful = this._gmaInitializer.initSuccessful(initStatus);
        this.findAndSendVersion(isInitSuccessful);
    }
}

