/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store.gpbl.proxies;

import com.unity3d.services.core.reflection.GenericListenerProxy;
import com.unity3d.services.store.gpbl.bridges.BillingResultBridge;
import com.unity3d.services.store.gpbl.bridges.PurchaseBridge;
import com.unity3d.services.store.listeners.IPurchasesResponseListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class PurchasesResponseListenerProxy
extends GenericListenerProxy {
    private static final String onQueryPurchasesResponseMethodName = "onQueryPurchasesResponse";
    private IPurchasesResponseListener _purchasesResponseListener;

    public PurchasesResponseListenerProxy(IPurchasesResponseListener purchasesResponseListener) {
        this._purchasesResponseListener = purchasesResponseListener;
    }

    @Override
    public Class<?> getProxyClass() throws ClassNotFoundException {
        return PurchasesResponseListenerProxy.getProxyListenerClass();
    }

    public static Class<?> getProxyListenerClass() throws ClassNotFoundException {
        return Class.forName("com.android.billingclient.api.PurchasesResponseListener");
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result = null;
        if (m.getName().equals(onQueryPurchasesResponseMethodName)) {
            this.onQueryPurchasesResponse(args[0], (List)args[1]);
        } else {
            result = super.invoke(proxy, m, args);
        }
        return result;
    }

    public void onQueryPurchasesResponse(Object billingResult, List<Object> purchases) {
        BillingResultBridge billingResultBridge = new BillingResultBridge(billingResult);
        ArrayList<PurchaseBridge> purchasesBridge = new ArrayList<PurchaseBridge>();
        for (Object purchase : purchases) {
            purchasesBridge.add(new PurchaseBridge(purchase));
        }
        this._purchasesResponseListener.onBillingResponse(billingResultBridge, (List<PurchaseBridge>)purchasesBridge);
    }
}

