/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.monetization.core.utilities;

import com.unity3d.services.core.log.DeviceLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtilities {
    public static Map<String, Object> jsonObjectToMap(JSONObject object) {
        HashMap<String, Object> map = new HashMap<String, Object>(object.length());
        Iterator it = object.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            try {
                Object value = JSONUtilities.mapTypeFromJSON(object.get(key));
                map.put(key, value);
            }
            catch (JSONException e) {
                DeviceLog.error("Could not put value in map: %s, %s", key, e.getMessage());
            }
        }
        return map;
    }

    public static List<Object> jsonArrayToList(JSONArray array) {
        ArrayList<Object> values = new ArrayList<Object>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            try {
                Object value = JSONUtilities.mapTypeFromJSON(array.get(i));
                values.add(value);
                continue;
            }
            catch (JSONException e) {
                DeviceLog.error("Could not put value into list: %s", e.getMessage());
            }
        }
        return values;
    }

    private static Object mapTypeFromJSON(Object value) {
        if (value instanceof JSONObject) {
            value = JSONUtilities.jsonObjectToMap((JSONObject)value);
        } else if (value instanceof JSONArray) {
            value = JSONUtilities.jsonArrayToList((JSONArray)value);
        }
        return value;
    }

    public static JSONObject mapToJsonObject(Map<String, Object> extras) {
        JSONObject object = new JSONObject();
        for (Map.Entry<String, Object> entry : extras.entrySet()) {
            try {
                object.put(entry.getKey(), JSONUtilities.wrap(entry.getValue()));
            }
            catch (JSONException e) {
                DeviceLog.error("Could not map entry to object: %s, %s", entry.getKey(), entry.getValue());
            }
        }
        return object;
    }

    public static Object wrap(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof JSONArray || o instanceof JSONObject) {
            return o;
        }
        if (o.equals(JSONObject.NULL)) {
            return o;
        }
        try {
            if (o instanceof Collection) {
                return new JSONArray((Collection)o);
            }
            if (o.getClass().isArray()) {
                return new JSONArray(Arrays.asList(o));
            }
            if (o instanceof Map) {
                return new JSONObject((Map)o);
            }
            if (o instanceof Boolean || o instanceof Byte || o instanceof Character || o instanceof Double || o instanceof Float || o instanceof Integer || o instanceof Long || o instanceof Short || o instanceof String) {
                return o;
            }
            if (o instanceof Enum) {
                return o.toString();
            }
            if (o.getClass().getPackage().getName().startsWith("java.")) {
                return o.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

