/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ar;

import android.annotation.TargetApi;
import android.content.Context;
import com.google.ar.core.ArCoreApk;
import com.google.ar.core.Config;
import com.google.ar.core.Session;
import com.google.ar.core.exceptions.FatalException;
import com.google.ar.core.exceptions.UnavailableException;
import com.unity3d.services.ar.ARCheck;
import com.unity3d.services.core.log.DeviceLog;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ARUtils {
    public static final int AR_CHECK_NOT_SUPPORTED = 0;
    public static final int AR_CHECK_SUPPORTED = 1;
    public static final int AR_CHECK_TRANSIENT = 2;
    private static Config.PlaneFindingMode[] planeFindingModes;
    private static Config.LightEstimationMode[] lightEstimationModes;
    private static Config.UpdateMode[] updateModes;

    public static int isSupported(Context context) {
        ArCoreApk.Availability availability;
        if (!ARCheck.isFrameworkPresent()) {
            return 0;
        }
        if (planeFindingModes == null) {
            planeFindingModes = Config.PlaneFindingMode.values();
            lightEstimationModes = Config.LightEstimationMode.values();
            updateModes = Config.UpdateMode.values();
        }
        if ((availability = ArCoreApk.getInstance().checkAvailability(context)).isTransient()) {
            return 2;
        }
        if (availability == ArCoreApk.Availability.SUPPORTED_INSTALLED) {
            try {
                Session session = new Session(context);
            }
            catch (FatalException | UnavailableException e) {
                return 0;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return 1;
        }
        return 0;
    }

    public static Config createConfiguration(JSONObject properties, Session session) {
        Config config = new Config(session);
        if (properties.has("lightEstimationMode")) {
            try {
                String lightEstimationMode = properties.getString("lightEstimationMode");
                for (Config.LightEstimationMode lightEstimationMode2 : lightEstimationModes) {
                    if (!lightEstimationMode.equalsIgnoreCase(lightEstimationMode2.name())) continue;
                    config.setLightEstimationMode(lightEstimationMode2);
                    break;
                }
            }
            catch (JSONException e) {
                DeviceLog.warning("lightEstimationEnabled is not a string.");
            }
        }
        if (properties.has("planeFindingMode")) {
            try {
                String planeFindingMode = properties.getString("planeFindingMode");
                for (Config.LightEstimationMode lightEstimationMode : planeFindingModes) {
                    if (!planeFindingMode.equalsIgnoreCase(lightEstimationMode.name())) continue;
                    config.setPlaneFindingMode((Config.PlaneFindingMode)lightEstimationMode);
                    break;
                }
            }
            catch (JSONException e) {
                DeviceLog.warning("planeFindingMode is not a string.");
            }
        }
        if (properties.has("updateMode")) {
            try {
                String updateMode = properties.getString("updateMode");
                for (Config.LightEstimationMode lightEstimationMode : updateModes) {
                    if (!updateMode.equalsIgnoreCase(lightEstimationMode.name())) continue;
                    config.setUpdateMode((Config.UpdateMode)lightEstimationMode);
                    break;
                }
            }
            catch (JSONException e) {
                DeviceLog.warning("updateMode is not a string.");
            }
        }
        return config;
    }

    @TargetApi(value=19)
    public static JSONObject getConfigEnums() {
        JSONObject enums = new JSONObject();
        try {
            ArrayList<String> values = new ArrayList<String>();
            for (Config.LightEstimationMode lightEstimationMode : Config.LightEstimationMode.values()) {
                values.add(lightEstimationMode.name());
            }
            enums.put("lightEstimationMode", (Object)new JSONArray((Object)values.toArray()));
            values.clear();
            for (Config.LightEstimationMode lightEstimationMode : Config.PlaneFindingMode.values()) {
                values.add(lightEstimationMode.name());
            }
            enums.put("planeFindingMode", (Object)new JSONArray((Object)values.toArray()));
            values.clear();
            for (Config.LightEstimationMode lightEstimationMode : Config.UpdateMode.values()) {
                values.add(lightEstimationMode.name());
            }
            enums.put("updateMode", (Object)new JSONArray((Object)values.toArray()));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return enums;
    }
}

