/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.assistant.thread;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ThreadMessage {
    private static final Logger log = LoggerFactory.getLogger(ThreadMessage.class);
    private String role;
    private String content;
    @JsonProperty(value="file_ids")
    private List<String> fileIds;
    private Map metadata;

    public static ThreadMessageBuilder builder() {
        return new ThreadMessageBuilder();
    }

    public String getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public Map getMetadata() {
        return this.metadata;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @JsonProperty(value="file_ids")
    public void setFileIds(List<String> fileIds) {
        this.fileIds = fileIds;
    }

    public void setMetadata(Map metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadMessage)) {
            return false;
        }
        ThreadMessage other = (ThreadMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<String> this$fileIds = this.getFileIds();
        List<String> other$fileIds = other.getFileIds();
        if (this$fileIds == null ? other$fileIds != null : !((Object)this$fileIds).equals(other$fileIds)) {
            return false;
        }
        Map this$metadata = this.getMetadata();
        Map other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<String> $fileIds = this.getFileIds();
        result = result * 59 + ($fileIds == null ? 43 : ((Object)$fileIds).hashCode());
        Map $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "ThreadMessage(role=" + this.getRole() + ", content=" + this.getContent() + ", fileIds=" + this.getFileIds() + ", metadata=" + this.getMetadata() + ")";
    }

    public ThreadMessage() {
    }

    public ThreadMessage(String role, String content, List<String> fileIds, Map metadata) {
        this.role = role;
        this.content = content;
        this.fileIds = fileIds;
        this.metadata = metadata;
    }

    public static class ThreadMessageBuilder {
        private String role;
        private String content;
        private List<String> fileIds;
        private Map metadata;

        ThreadMessageBuilder() {
        }

        public ThreadMessageBuilder role(String role) {
            this.role = role;
            return this;
        }

        public ThreadMessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        @JsonProperty(value="file_ids")
        public ThreadMessageBuilder fileIds(List<String> fileIds) {
            this.fileIds = fileIds;
            return this;
        }

        public ThreadMessageBuilder metadata(Map metadata) {
            this.metadata = metadata;
            return this;
        }

        public ThreadMessage build() {
            return new ThreadMessage(this.role, this.content, this.fileIds, this.metadata);
        }

        public String toString() {
            return "ThreadMessage.ThreadMessageBuilder(role=" + this.role + ", content=" + this.content + ", fileIds=" + this.fileIds + ", metadata=" + this.metadata + ")";
        }
    }

    public static enum Role {
        USER("user");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Role(String name) {
            this.name = name;
        }
    }
}

