/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.providers;

import com.unboundid.scim2.common.messages.ErrorResponse;
import com.unboundid.scim2.server.utils.ServerUtils;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class RuntimeExceptionMapper
implements ExceptionMapper<RuntimeException> {
    @Context
    private Request request;
    @Context
    private HttpHeaders headers;

    public Response toResponse(RuntimeException exception) {
        ErrorResponse errorResponse;
        if (exception instanceof WebApplicationException) {
            if (exception.getCause() != null && exception.getCause() instanceof NoContentException) {
                errorResponse = new ErrorResponse(400);
                errorResponse.setScimType("invalidSyntax");
                errorResponse.setDetail("No content provided. A valid SCIM object represented as a json document is required");
            } else {
                errorResponse = new ErrorResponse(((WebApplicationException)exception).getResponse().getStatus());
                errorResponse.setDetail(exception.getMessage());
            }
        } else {
            errorResponse = new ErrorResponse(500);
            errorResponse.setDetail(exception.toString());
        }
        return ServerUtils.setAcceptableType(Response.status((int)errorResponse.getStatus()).entity((Object)errorResponse), this.headers.getAcceptableMediaTypes()).build();
    }
}

