/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.types.AttributeDefinition;
import com.unboundid.scim2.common.types.SchemaResource;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.server.utils.ResourcePreparer;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import java.net.URI;
import java.util.ArrayList;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ResourcePreparerTestCase {
    private ResourceTypeDefinition resourceTypeDefinition;
    private GenericScimResource testResource;
    private ArrayList<PatchOperation> testPatch;
    private URI testBaseUri = URI.create("https://test/scim");

    @BeforeClass
    public void setUp() throws Exception {
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>(4);
        AttributeDefinition.Builder builder = new AttributeDefinition.Builder();
        builder.setName("always");
        builder.setType(AttributeDefinition.Type.STRING);
        builder.setReturned(AttributeDefinition.Returned.ALWAYS);
        attributeDefinitions.add(builder.build());
        builder.setName("never");
        builder.setReturned(AttributeDefinition.Returned.NEVER);
        attributeDefinitions.add(builder.build());
        builder.setName("default");
        builder.setReturned(AttributeDefinition.Returned.DEFAULT);
        attributeDefinitions.add(builder.build());
        builder.setName("request");
        builder.setReturned(AttributeDefinition.Returned.REQUEST);
        attributeDefinitions.add(builder.build());
        AttributeDefinition[] attributeDefinitionsArray = attributeDefinitions.toArray(new AttributeDefinition[attributeDefinitions.size()]);
        ArrayList<AttributeDefinition> complexAttributeDefinitions = new ArrayList<AttributeDefinition>(4);
        builder = new AttributeDefinition.Builder();
        builder.setName("always");
        builder.setType(AttributeDefinition.Type.COMPLEX);
        builder.setReturned(AttributeDefinition.Returned.ALWAYS);
        builder.addSubAttributes(attributeDefinitionsArray);
        complexAttributeDefinitions.add(builder.build());
        builder.setName("never");
        builder.setReturned(AttributeDefinition.Returned.NEVER);
        complexAttributeDefinitions.add(builder.build());
        builder.setName("default");
        builder.setReturned(AttributeDefinition.Returned.DEFAULT);
        complexAttributeDefinitions.add(builder.build());
        builder.setName("request");
        builder.setReturned(AttributeDefinition.Returned.REQUEST);
        complexAttributeDefinitions.add(builder.build());
        SchemaResource schema = new SchemaResource("urn:test", "test", "test", complexAttributeDefinitions);
        SchemaResource extensionSchema = new SchemaResource("urn:ext:1", "ext", "ext", complexAttributeDefinitions);
        this.resourceTypeDefinition = new ResourceTypeDefinition.Builder("test", "test").setCoreSchema(schema).addOptionalSchemaExtension(extensionSchema).build();
        ObjectNode node = (ObjectNode)JsonUtils.getObjectReader().readTree("{  \n  \"id\":\"test\",\n  \"always\":\n  {\n    \"always\":\"here\",\n    \"neVEr\":\"here\",\n    \"default\":\"here\",\n    \"rEquest\":\"here\"\n  },\n  \"neVEr\":\n  {\n    \"always\":\"here\",\n    \"neVEr\":\"here\",\n    \"default\":\"here\",\n    \"rEquest\":\"here\"\n  },\n  \"default\":\n  {\n    \"always\":\"here\",\n    \"neVEr\":\"here\",\n    \"default\":\"here\",\n    \"notDeclared\":\"here\",\n    \"rEquest\":\"here\"\n  },\n  \"rEquest\":\n  {\n    \"always\":\"here\",\n    \"neVEr\":\"here\",\n    \"default\":\"here\",\n    \"rEquest\":\"here\"\n  },\n  \"urn:ext:1\":\n  {\n    \"always\":\n    {\n      \"always\":\"here\",\n      \"neVEr\":\"here\",\n      \"default\":\"here\",\n      \"rEquest\":\"here\"\n    },\n    \"neVEr\":\n    {\n      \"always\":\"here\",\n      \"neVEr\":\"here\",\n      \"default\":\"here\",\n      \"rEquest\":\"here\"\n    },\n    \"default\":\n    {\n      \"always\":\"here\",\n      \"neVEr\":\"here\",\n      \"default\":\"here\",\n      \"rEquest\":\"here\"\n    },\n    \"rEquest\":\n    {\n      \"always\":\"here\",\n      \"neVEr\":\"here\",\n      \"default\":\"here\",\n      \"rEquest\":\"here\"\n    }\n  }\n}");
        this.testResource = new GenericScimResource(node);
        this.testPatch = new ArrayList(4);
        this.testPatch.add(PatchOperation.add((Path)Path.fromString((String)"alWays"), (JsonNode)new TextNode("test")));
        this.testPatch.add(PatchOperation.add((Path)Path.fromString((String)"neveR"), (JsonNode)new TextNode("test")));
        this.testPatch.add(PatchOperation.add((Path)Path.fromString((String)"defauLt"), (JsonNode)new TextNode("test")));
        this.testPatch.add(PatchOperation.add((Path)Path.fromString((String)"Request"), (JsonNode)new TextNode("test")));
    }

    @DataProvider
    public Object[][] dataProvider() {
        return new Object[][]{{null, null}, {null, "always"}, {null, "always.default"}, {null, "never"}, {null, "urn:test:default"}, {null, "reQuest"}, {null, "default.DEFAULT"}, {"Always", null}, {"neveR", null}, {"urn:test:DEFAULT", null}, {"default.DEFAULT", null}, {"request", null}, {null, "urn:ext:1:always"}, {null, "urn:ext:1:never"}, {null, "urn:ext:1:default"}, {null, "urn:ext:1:reQuest"}, {"urn:ext:1:Always", null}, {"urn:ext:1:neveR", null}, {"urn:ext:1:DEFAULT", null}, {"urn:ext:1:request", null}};
    }

    @Test(dataProvider="dataProvider")
    public void testRetrieve(String attributes, String excludedAttributes) throws BadRequestException {
        ResourcePreparer preparer = new ResourcePreparer(this.resourceTypeDefinition, attributes, excludedAttributes, this.testBaseUri);
        GenericScimResource prepared = preparer.trimRetrievedResource((ScimResource)this.testResource);
        Assert.assertTrue((boolean)prepared.getObjectNode().has("always"));
        ObjectNode innerNode = (ObjectNode)prepared.getObjectNode().get("always");
        Assert.assertTrue((boolean)innerNode.has("always"));
        if (excludedAttributes != null && excludedAttributes.equalsIgnoreCase("always.default")) {
            Assert.assertFalse((boolean)innerNode.has("default"));
        }
        Assert.assertFalse((boolean)innerNode.has("never"));
        Assert.assertFalse((boolean)prepared.getObjectNode().has("never"));
        if (attributes == null && excludedAttributes == null || excludedAttributes != null && !excludedAttributes.equalsIgnoreCase("urn:test:default") && !excludedAttributes.equalsIgnoreCase("default.default") || attributes != null && (attributes.equalsIgnoreCase("urn:test:default") || attributes.equalsIgnoreCase("default.default"))) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("default"));
            if (attributes != null && attributes.equalsIgnoreCase("default.default")) {
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("default"));
                Assert.assertFalse((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            }
            if (attributes != null && attributes.equalsIgnoreCase("urn:test:default")) {
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("default"));
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            }
        } else if (excludedAttributes != null && excludedAttributes.equalsIgnoreCase("default.default")) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("default"));
            Assert.assertFalse((boolean)prepared.getObjectNode().get("default").has("default"));
            Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("always"));
        } else {
            Assert.assertFalse((boolean)prepared.getObjectNode().has("default"));
        }
        if (attributes != null && attributes.equalsIgnoreCase("request")) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("request"));
            innerNode = (ObjectNode)prepared.getObjectNode().get("request");
            Assert.assertTrue((boolean)innerNode.has("always"));
            Assert.assertFalse((boolean)innerNode.has("never"));
            Assert.assertTrue((boolean)innerNode.has("request"), (String)prepared.toString());
        } else {
            Assert.assertFalse((boolean)prepared.getObjectNode().has("request"));
        }
        Assert.assertTrue((boolean)prepared.getObjectNode().has("urn:ext:1"));
        ObjectNode extNode = (ObjectNode)prepared.getObjectNode().get("urn:ext:1");
        Assert.assertTrue((boolean)extNode.has("always"));
        Assert.assertFalse((boolean)extNode.has("never"));
        if (attributes == null && excludedAttributes == null || excludedAttributes != null && !excludedAttributes.equalsIgnoreCase("urn:ext:1:default") || attributes != null && attributes.equalsIgnoreCase("urn:ext:1:default")) {
            Assert.assertTrue((boolean)extNode.has("default"));
        } else {
            Assert.assertFalse((boolean)extNode.has("default"));
        }
        if (attributes != null && attributes.equalsIgnoreCase("urn:ext:1:request")) {
            Assert.assertTrue((boolean)extNode.has("request"));
        } else {
            Assert.assertFalse((boolean)extNode.has("request"));
        }
    }

    @Test(dataProvider="dataProvider")
    public void testCreate(String attributes, String excludedAttributes) throws BadRequestException {
        ResourcePreparer preparer = new ResourcePreparer(this.resourceTypeDefinition, attributes, excludedAttributes, this.testBaseUri);
        GenericScimResource prepared = preparer.trimCreatedResource((ScimResource)this.testResource, null);
        Assert.assertTrue((boolean)prepared.getObjectNode().has("always"));
        if (excludedAttributes != null && excludedAttributes.equalsIgnoreCase("always.default")) {
            Assert.assertFalse((boolean)prepared.getObjectNode().get("always").has("default"));
        }
        Assert.assertFalse((boolean)prepared.getObjectNode().has("never"));
        if (attributes == null && excludedAttributes == null || excludedAttributes != null && !excludedAttributes.equalsIgnoreCase("urn:test:default") && !excludedAttributes.equalsIgnoreCase("default.default") || attributes != null && (attributes.equalsIgnoreCase("urn:test:default") || attributes.equalsIgnoreCase("default.default"))) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("default"));
            if (attributes != null && attributes.equalsIgnoreCase("default.default")) {
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("default"));
                Assert.assertFalse((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            }
            if (attributes != null && attributes.equalsIgnoreCase("urn:test:default")) {
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("default"));
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            }
        } else if (excludedAttributes != null && excludedAttributes.equalsIgnoreCase("default.default")) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("default"));
            Assert.assertFalse((boolean)prepared.getObjectNode().get("default").has("default"));
            Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("always"));
        } else {
            Assert.assertFalse((boolean)prepared.getObjectNode().has("default"));
        }
        if (attributes != null && attributes.equalsIgnoreCase("request")) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("request"));
        } else {
            Assert.assertFalse((boolean)prepared.getObjectNode().has("request"));
        }
        prepared = preparer.trimCreatedResource((ScimResource)this.testResource, (ScimResource)this.testResource);
        Assert.assertTrue((boolean)prepared.getObjectNode().has("always"));
        if (excludedAttributes != null && excludedAttributes.equalsIgnoreCase("always.default")) {
            Assert.assertFalse((boolean)prepared.getObjectNode().get("always").has("default"));
        }
        Assert.assertFalse((boolean)prepared.getObjectNode().has("never"));
        if (attributes == null && excludedAttributes == null || excludedAttributes != null && !excludedAttributes.equalsIgnoreCase("urn:test:default") && !excludedAttributes.equalsIgnoreCase("default.default") || attributes != null && (attributes.equalsIgnoreCase("urn:test:default") || attributes.equalsIgnoreCase("default.default"))) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("default"));
            if (attributes != null && attributes.equalsIgnoreCase("default.default")) {
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("default"));
                Assert.assertFalse((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            }
            if (attributes != null && attributes.equalsIgnoreCase("urn:test:default")) {
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("default"));
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            }
        } else if (excludedAttributes != null && excludedAttributes.equalsIgnoreCase("default.default")) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("default"));
            Assert.assertFalse((boolean)prepared.getObjectNode().get("default").has("default"));
            Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("always"));
        } else {
            Assert.assertFalse((boolean)prepared.getObjectNode().has("default"));
        }
        Assert.assertTrue((boolean)prepared.getObjectNode().has("request"));
    }

    @Test(dataProvider="dataProvider")
    public void testReplace(String attributes, String excludedAttributes) throws BadRequestException {
        ResourcePreparer preparer = new ResourcePreparer(this.resourceTypeDefinition, attributes, excludedAttributes, this.testBaseUri);
        GenericScimResource prepared = preparer.trimReplacedResource((ScimResource)this.testResource, null);
        Assert.assertTrue((boolean)prepared.getObjectNode().has("always"));
        if (excludedAttributes != null && excludedAttributes.equalsIgnoreCase("always.default")) {
            Assert.assertFalse((boolean)prepared.getObjectNode().get("always").has("default"));
        }
        Assert.assertFalse((boolean)prepared.getObjectNode().has("never"));
        if (attributes == null && excludedAttributes == null || excludedAttributes != null && !excludedAttributes.equalsIgnoreCase("urn:test:default") && !excludedAttributes.equalsIgnoreCase("default.default") || attributes != null && (attributes.equalsIgnoreCase("urn:test:default") || attributes.equalsIgnoreCase("default.default"))) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("default"));
            if (attributes != null && attributes.equalsIgnoreCase("default.default")) {
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("default"));
                Assert.assertFalse((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            }
            if (attributes != null && attributes.equalsIgnoreCase("urn:test:default")) {
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("default"));
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            }
        } else if (excludedAttributes != null && excludedAttributes.equalsIgnoreCase("default.default")) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("default"));
            Assert.assertFalse((boolean)prepared.getObjectNode().get("default").has("default"));
            Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("always"));
        } else {
            Assert.assertFalse((boolean)prepared.getObjectNode().has("default"));
        }
        if (attributes != null && attributes.equalsIgnoreCase("request")) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("request"));
        } else {
            Assert.assertFalse((boolean)prepared.getObjectNode().has("request"));
        }
        prepared = preparer.trimReplacedResource((ScimResource)this.testResource, (ScimResource)this.testResource);
        Assert.assertTrue((boolean)prepared.getObjectNode().has("always"));
        if (excludedAttributes != null && excludedAttributes.equalsIgnoreCase("always.default")) {
            Assert.assertFalse((boolean)prepared.getObjectNode().get("always").has("default"));
        }
        Assert.assertFalse((boolean)prepared.getObjectNode().has("never"));
        if (attributes == null && excludedAttributes == null || excludedAttributes != null && !excludedAttributes.equalsIgnoreCase("urn:test:default") && !excludedAttributes.equalsIgnoreCase("default.default") || attributes != null && (attributes.equalsIgnoreCase("urn:test:default") || attributes.equalsIgnoreCase("default.default"))) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("default"));
            if (attributes != null && attributes.equalsIgnoreCase("default.default")) {
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("default"));
                Assert.assertFalse((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            }
            if (attributes != null && attributes.equalsIgnoreCase("urn:test:default")) {
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("default"));
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            }
        } else if (excludedAttributes != null && excludedAttributes.equalsIgnoreCase("default.default")) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("default"));
            Assert.assertFalse((boolean)prepared.getObjectNode().get("default").has("default"));
            Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("always"));
        } else {
            Assert.assertFalse((boolean)prepared.getObjectNode().has("default"));
        }
        Assert.assertTrue((boolean)prepared.getObjectNode().has("request"));
    }

    @Test(dataProvider="dataProvider")
    public void testModify(String attributes, String excludedAttributes) throws BadRequestException {
        ResourcePreparer preparer = new ResourcePreparer(this.resourceTypeDefinition, attributes, excludedAttributes, this.testBaseUri);
        GenericScimResource prepared = preparer.trimModifiedResource((ScimResource)this.testResource, null);
        Assert.assertTrue((boolean)prepared.getObjectNode().has("always"));
        if (excludedAttributes != null && excludedAttributes.equalsIgnoreCase("always.default")) {
            Assert.assertFalse((boolean)prepared.getObjectNode().get("always").has("default"));
        }
        Assert.assertFalse((boolean)prepared.getObjectNode().has("never"));
        if (attributes == null && excludedAttributes == null || excludedAttributes != null && !excludedAttributes.equalsIgnoreCase("urn:test:default") && !excludedAttributes.equalsIgnoreCase("default.default") || attributes != null && (attributes.equalsIgnoreCase("urn:test:default") || attributes.equalsIgnoreCase("default.default"))) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("default"));
            if (attributes != null && attributes.equalsIgnoreCase("default.default")) {
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("default"));
                Assert.assertFalse((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            }
            if (attributes != null && attributes.equalsIgnoreCase("urn:test:default")) {
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("default"));
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            }
        } else if (excludedAttributes != null && excludedAttributes.equalsIgnoreCase("default.default")) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("default"));
            Assert.assertFalse((boolean)prepared.getObjectNode().get("default").has("default"));
            Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("always"));
        } else {
            Assert.assertFalse((boolean)prepared.getObjectNode().has("default"));
        }
        if (attributes != null && attributes.equalsIgnoreCase("request")) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("request"));
        } else {
            Assert.assertFalse((boolean)prepared.getObjectNode().has("request"));
        }
        prepared = preparer.trimModifiedResource((ScimResource)this.testResource, this.testPatch);
        Assert.assertTrue((boolean)prepared.getObjectNode().has("always"));
        if (excludedAttributes != null && excludedAttributes.equalsIgnoreCase("always.default")) {
            Assert.assertFalse((boolean)prepared.getObjectNode().get("always").has("default"));
        }
        Assert.assertFalse((boolean)prepared.getObjectNode().has("never"));
        if (attributes == null && excludedAttributes == null || excludedAttributes != null && !excludedAttributes.equalsIgnoreCase("urn:test:default") && !excludedAttributes.equalsIgnoreCase("default.default") || attributes != null && (attributes.equalsIgnoreCase("urn:test:default") || attributes.equalsIgnoreCase("default.default"))) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("default"));
            if (attributes != null && attributes.equalsIgnoreCase("default.default")) {
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("default"));
                Assert.assertFalse((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            }
            if (attributes != null && attributes.equalsIgnoreCase("urn:test:default")) {
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("default"));
                Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            }
        } else if (excludedAttributes != null && excludedAttributes.equalsIgnoreCase("default.default")) {
            Assert.assertTrue((boolean)prepared.getObjectNode().has("default"));
            Assert.assertFalse((boolean)prepared.getObjectNode().get("default").has("default"));
            Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("notDeclared"));
            Assert.assertTrue((boolean)prepared.getObjectNode().get("default").has("always"));
        } else {
            Assert.assertFalse((boolean)prepared.getObjectNode().has("default"));
        }
        Assert.assertTrue((boolean)prepared.getObjectNode().has("request"));
    }

    @Test
    public void testEmptyContainer() throws Exception {
        ResourcePreparer preparer = new ResourcePreparer(this.resourceTypeDefinition, "default", null, this.testBaseUri);
        ObjectNode node = (ObjectNode)JsonUtils.getObjectReader().readTree("{\n  \"default\": {\n    \"never\": \"here\"\n  }\n}");
        GenericScimResource prepared = preparer.trimRetrievedResource((ScimResource)new GenericScimResource(node));
        Assert.assertFalse((boolean)prepared.getObjectNode().has("default"));
        node = (ObjectNode)JsonUtils.getObjectReader().readTree("{\n  \"default\": [\n    {\n      \"never\": \"here\"\n    },\n    {\n      \"always\": \"here\"\n    }\n  ]\n}");
        prepared = preparer.trimRetrievedResource((ScimResource)new GenericScimResource(node));
        Assert.assertTrue((boolean)prepared.getObjectNode().has("default"));
        Assert.assertEquals((int)prepared.getObjectNode().get("default").size(), (int)1);
        node = (ObjectNode)JsonUtils.getObjectReader().readTree("{\n  \"default\": [\n    {\n      \"never\": \"here\"\n    },\n    {\n      \"never\": \"here\"\n    }\n  ]\n}");
        prepared = preparer.trimRetrievedResource((ScimResource)new GenericScimResource(node));
        Assert.assertFalse((boolean)prepared.getObjectNode().has("default"));
        node = (ObjectNode)JsonUtils.getObjectReader().readTree("{\n  \"urn:ext:1\": {\n    \"never\": \"here\"\n  }\n}");
        prepared = preparer.trimRetrievedResource((ScimResource)new GenericScimResource(node));
        Assert.assertFalse((boolean)prepared.getObjectNode().has("urn:ext:1"));
    }
}

