/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.types.EnterpriseUserExtension;
import com.unboundid.scim2.common.types.UserResource;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.server.PATCH;
import com.unboundid.scim2.server.annotations.ResourceType;
import com.unboundid.scim2.server.utils.ResourcePreparer;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import com.unboundid.scim2.server.utils.SimpleSearchResults;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceType(description="Singleton User Account", name="Singleton User", schema=UserResource.class, requiredSchemaExtensions={EnterpriseUserExtension.class})
@Path(value="/SingletonUsers")
public class TestSingletonResourceEndpoint {
    private static final ResourceTypeDefinition RESOURCE_TYPE_DEFINITION = ResourceTypeDefinition.fromJaxRsResource(TestSingletonResourceEndpoint.class);
    private final Map<String, UserResource> users = new HashMap<String, UserResource>();

    @GET
    @Produces(value={"application/scim+json", "application/json"})
    public SimpleSearchResults<UserResource> search(@Context UriInfo uriInfo) throws ScimException {
        SimpleSearchResults results = new SimpleSearchResults(RESOURCE_TYPE_DEFINITION, uriInfo);
        results.addAll(this.users.values());
        return results;
    }

    @Path(value="{id}")
    @GET
    @Produces(value={"application/scim+json", "application/json"})
    public ScimResource retrieve(@PathParam(value="id") String id, @Context UriInfo uriInfo) throws ScimException {
        UserResource found = this.users.get(id);
        if (found == null) {
            throw new ResourceNotFoundException("No resource with ID " + id);
        }
        ResourcePreparer resourcePreparer = new ResourcePreparer(RESOURCE_TYPE_DEFINITION, uriInfo);
        return resourcePreparer.trimRetrievedResource((ScimResource)found);
    }

    @POST
    @Consumes(value={"application/scim+json", "application/json"})
    @Produces(value={"application/scim+json", "application/json"})
    public ScimResource create(UserResource resource, @Context UriInfo uriInfo) throws ScimException {
        resource.setId(String.valueOf(resource.hashCode()));
        this.users.put(resource.getId(), resource);
        ResourcePreparer resourcePreparer = new ResourcePreparer(RESOURCE_TYPE_DEFINITION, uriInfo);
        return resourcePreparer.trimCreatedResource((ScimResource)resource, (ScimResource)resource);
    }

    @Path(value="{id}")
    @DELETE
    public void delete(@PathParam(value="id") String id) throws ScimException {
        UserResource found = this.users.remove(id);
        if (found == null) {
            throw new ResourceNotFoundException("No resource with ID " + id);
        }
    }

    @Path(value="{id}")
    @PUT
    @Consumes(value={"application/scim+json", "application/json"})
    @Produces(value={"application/scim+json", "application/json"})
    public ScimResource replace(@PathParam(value="id") String id, UserResource resource, @Context UriInfo uriInfo) throws ScimException {
        if (!this.users.containsKey(id)) {
            throw new ResourceNotFoundException("No resource with ID " + id);
        }
        this.users.put(id, resource);
        ResourcePreparer resourcePreparer = new ResourcePreparer(RESOURCE_TYPE_DEFINITION, uriInfo);
        return resourcePreparer.trimReplacedResource((ScimResource)resource, (ScimResource)resource);
    }

    @Path(value="{id}")
    @PATCH
    @Consumes(value={"application/scim+json", "application/json"})
    @Produces(value={"application/scim+json", "application/json"})
    public ScimResource modify(@PathParam(value="id") String id, PatchRequest patchRequest, @Context UriInfo uriInfo) throws ScimException {
        UserResource found = this.users.get(id);
        if (found == null) {
            throw new ResourceNotFoundException("No resource with ID " + id);
        }
        ObjectNode node = (ObjectNode)JsonUtils.valueToNode((Object)found);
        for (PatchOperation operation : patchRequest) {
            operation.apply(node);
        }
        UserResource patchedFound = null;
        try {
            patchedFound = (UserResource)JsonUtils.getObjectReader().treeToValue((TreeNode)node, UserResource.class);
        }
        catch (JsonProcessingException e) {
            throw new ServerErrorException(e.getMessage(), null, (Throwable)e);
        }
        this.users.put(id, patchedFound);
        ResourcePreparer resourcePreparer = new ResourcePreparer(RESOURCE_TYPE_DEFINITION, uriInfo);
        return resourcePreparer.trimModifiedResource((ScimResource)patchedFound, (Iterable)patchRequest);
    }
}

