/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.jaxrs.cfg.JaxRSFeature;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.common.collect.Lists;
import com.unboundid.scim2.client.ScimService;
import com.unboundid.scim2.client.ScimServiceException;
import com.unboundid.scim2.client.requests.CreateRequestBuilder;
import com.unboundid.scim2.client.requests.DeleteRequestBuilder;
import com.unboundid.scim2.client.requests.ModifyRequestBuilder;
import com.unboundid.scim2.client.requests.ReplaceRequestBuilder;
import com.unboundid.scim2.client.requests.RetrieveRequestBuilder;
import com.unboundid.scim2.client.requests.SearchRequestBuilder;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.MethodNotAllowedException;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.ErrorResponse;
import com.unboundid.scim2.common.messages.ListResponse;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.messages.SearchRequest;
import com.unboundid.scim2.common.messages.SortOrder;
import com.unboundid.scim2.common.types.Email;
import com.unboundid.scim2.common.types.EnterpriseUserExtension;
import com.unboundid.scim2.common.types.Meta;
import com.unboundid.scim2.common.types.Name;
import com.unboundid.scim2.common.types.PhoneNumber;
import com.unboundid.scim2.common.types.ResourceTypeResource;
import com.unboundid.scim2.common.types.SchemaResource;
import com.unboundid.scim2.common.types.ServiceProviderConfigResource;
import com.unboundid.scim2.common.types.UserResource;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.common.utils.SchemaUtils;
import com.unboundid.scim2.server.CustomContentEndpoint;
import com.unboundid.scim2.server.TestAuthenticatedSubjectAliasFilter;
import com.unboundid.scim2.server.TestRequestFilter;
import com.unboundid.scim2.server.TestResourceEndpoint;
import com.unboundid.scim2.server.TestServiceProviderConfigEndpoint;
import com.unboundid.scim2.server.TestSingletonResourceEndpoint;
import com.unboundid.scim2.server.providers.DefaultContentTypeFilter;
import com.unboundid.scim2.server.providers.DotSearchFilter;
import com.unboundid.scim2.server.providers.JsonProcessingExceptionMapper;
import com.unboundid.scim2.server.providers.RuntimeExceptionMapper;
import com.unboundid.scim2.server.providers.ScimExceptionMapper;
import com.unboundid.scim2.server.resources.ResourceTypesEndpoint;
import com.unboundid.scim2.server.resources.SchemasEndpoint;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import com.unboundid.scim2.server.utils.ServerUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.test.JerseyTestNg;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointTestCase
extends JerseyTestNg.ContainerPerClassTest {
    private SchemaResource userSchema;
    private SchemaResource enterpriseSchema;
    private ResourceTypeResource resourceType;
    private ResourceTypeResource singletonResourceType;
    private ServiceProviderConfigResource serviceProviderConfig;
    private TestRequestFilter requestFilter;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register(ScimExceptionMapper.class);
        config.register(RuntimeExceptionMapper.class);
        config.register(JsonProcessingExceptionMapper.class);
        JacksonJsonProvider provider = new JacksonJsonProvider(JsonUtils.createObjectMapper());
        provider.configure(JaxRSFeature.ALLOW_EMPTY_INPUT, false);
        config.register((Object)provider);
        config.register(DotSearchFilter.class);
        config.register(TestAuthenticatedSubjectAliasFilter.class);
        config.register(DefaultContentTypeFilter.class);
        this.requestFilter = new TestRequestFilter();
        config.register((Object)this.requestFilter);
        config.register(ResourceTypesEndpoint.class);
        config.register(CustomContentEndpoint.class);
        config.register(SchemasEndpoint.class);
        config.register(TestServiceProviderConfigEndpoint.class);
        config.register(TestResourceEndpoint.class);
        config.register((Object)new TestSingletonResourceEndpoint());
        return config;
    }

    protected void configureClient(ClientConfig config) {
        config.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
    }

    @BeforeClass
    public void setUp() throws Exception {
        super.setUp();
        try {
            this.userSchema = SchemaUtils.getSchema(UserResource.class);
            this.setMeta(SchemasEndpoint.class, (ScimResource)this.userSchema);
            this.enterpriseSchema = SchemaUtils.getSchema(EnterpriseUserExtension.class);
            this.setMeta(SchemasEndpoint.class, (ScimResource)this.enterpriseSchema);
            this.resourceType = new ResourceTypeResource("User", "User Account", new URI("/Users"), new URI(this.userSchema.getId()));
            this.setMeta(ResourceTypesEndpoint.class, (ScimResource)this.resourceType);
            this.singletonResourceType = new ResourceTypeResource("Singleton User", "Singleton User", "Singleton User Account", new URI("/SingletonUsers"), new URI(this.userSchema.getId()), Collections.singletonList(new ResourceTypeResource.SchemaExtension(new URI(this.enterpriseSchema.getId()), true)));
            this.setMeta(ResourceTypesEndpoint.class, (ScimResource)this.singletonResourceType);
            this.serviceProviderConfig = TestServiceProviderConfigEndpoint.create();
            this.setMeta(TestServiceProviderConfigEndpoint.class, (ScimResource)this.serviceProviderConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testGetServiceProviderConfig() throws ScimException {
        ServiceProviderConfigResource returnedServiceProviderConfig = new ScimService(this.target()).getServiceProviderConfig();
        Assert.assertEquals((Object)returnedServiceProviderConfig, (Object)this.serviceProviderConfig);
    }

    @Test
    public void testPutServiceProviderConfig() {
        try {
            ScimService scimService = new ScimService(this.target());
            scimService.modifyRequest((ScimResource)scimService.getServiceProviderConfig()).invoke();
        }
        catch (WebApplicationException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)501);
            ErrorResponse errorResponse = (ErrorResponse)e.getResponse().readEntity(ErrorResponse.class);
            Assert.assertEquals((Object)errorResponse.getStatus(), (Object)new Integer(501));
        }
        catch (ScimException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testInvalidEndpoint() {
        try {
            new ScimService(this.target()).retrieve("badPath", "id", UserResource.class);
            Assert.fail();
        }
        catch (ScimException e) {
            Assert.assertTrue((boolean)(e instanceof ResourceNotFoundException));
        }
        WebTarget target = (WebTarget)this.target().register((Object)new JacksonJsonProvider(JsonUtils.createObjectMapper()));
        Response response = target.path("badPath").path("id").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE, ServerUtils.MEDIA_TYPE_SCIM_TYPE}).get();
        Assert.assertEquals((int)response.getStatus(), (int)404);
        Assert.assertEquals((Object)response.getMediaType(), (Object)MediaType.APPLICATION_JSON_TYPE);
    }

    @Test
    public void testGetSchemas() throws ScimException {
        ListResponse returnedSchemas = new ScimService(this.target()).getSchemas();
        Assert.assertEquals((long)returnedSchemas.getTotalResults(), (long)2L);
        Assert.assertTrue((boolean)this.contains((Iterable)returnedSchemas, (Object)this.userSchema));
        Assert.assertTrue((boolean)this.contains((Iterable)returnedSchemas, (Object)this.enterpriseSchema));
        WebTarget target = (WebTarget)this.target().register((Object)new JacksonJsonProvider(JsonUtils.createObjectMapper()));
        Response response = target.path("Schemas").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE, ServerUtils.MEDIA_TYPE_SCIM_TYPE}).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        Assert.assertEquals((Object)response.getMediaType(), (Object)MediaType.APPLICATION_JSON_TYPE);
    }

    @Test
    public void testGetSchema() throws ScimException {
        SchemaResource returnedSchema = new ScimService(this.target()).getSchema(this.userSchema.getId());
        Assert.assertEquals((Object)returnedSchema, (Object)this.userSchema);
        returnedSchema = new ScimService(this.target()).getSchema(this.enterpriseSchema.getId());
        Assert.assertEquals((Object)returnedSchema, (Object)this.enterpriseSchema);
        WebTarget target = (WebTarget)this.target().register((Object)new JacksonJsonProvider(JsonUtils.createObjectMapper()));
        Response response = target.path("Schemas").path(this.userSchema.getId()).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE, ServerUtils.MEDIA_TYPE_SCIM_TYPE}).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        Assert.assertEquals((Object)response.getMediaType(), (Object)MediaType.APPLICATION_JSON_TYPE);
    }

    @Test
    public void testGetResourceTypes() throws ScimException {
        ListResponse returnedResourceTypes = new ScimService(this.target()).getResourceTypes();
        Assert.assertEquals((long)returnedResourceTypes.getTotalResults(), (long)3L);
        Assert.assertTrue((boolean)this.contains((Iterable)returnedResourceTypes, (Object)this.resourceType));
        Assert.assertTrue((boolean)this.contains((Iterable)returnedResourceTypes, (Object)this.singletonResourceType));
        WebTarget target = (WebTarget)this.target().register((Object)new JacksonJsonProvider(JsonUtils.createObjectMapper()));
        Response response = target.path("ResourceTypes").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE, ServerUtils.MEDIA_TYPE_SCIM_TYPE}).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        Assert.assertEquals((Object)response.getMediaType(), (Object)MediaType.APPLICATION_JSON_TYPE);
    }

    @Test
    public void testGetResourceType() throws ScimException {
        ResourceTypeResource returnedResourceTypeById = new ScimService(this.target()).getResourceType(this.resourceType.getId());
        Assert.assertEquals((Object)returnedResourceTypeById, (Object)this.resourceType);
        ResourceTypeResource returnedResourceTypeByName = new ScimService(this.target()).getResourceType(this.singletonResourceType.getId());
        Assert.assertEquals((Object)returnedResourceTypeByName, (Object)this.singletonResourceType);
        SchemaResource returnedSchema = new ScimService(this.target()).getSchema(returnedResourceTypeById.getSchema().toString());
        Assert.assertEquals((Object)returnedSchema, (Object)this.userSchema);
        WebTarget target = (WebTarget)this.target().register((Object)new JacksonJsonProvider(JsonUtils.createObjectMapper()));
        Response response = target.path("ResourceTypes").path(this.resourceType.getId()).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE, ServerUtils.MEDIA_TYPE_SCIM_TYPE}).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        Assert.assertEquals((Object)response.getMediaType(), (Object)MediaType.APPLICATION_JSON_TYPE);
    }

    @Test
    public void testGetUsers() throws ScimException {
        ScimService service = new ScimService(this.target());
        ListResponse returnedUsers = ((SearchRequestBuilder)service.searchRequest("Users").filter("meta.resourceType eq \"User\"").page(1, 10).sort("id", SortOrder.ASCENDING).attributes(new String[]{"id", "name", "Meta"})).invoke(UserResource.class);
        Assert.assertEquals((long)returnedUsers.getTotalResults(), (long)1L);
        Assert.assertEquals((Object)returnedUsers.getStartIndex(), (Object)new Integer(1));
        Assert.assertEquals((Object)returnedUsers.getItemsPerPage(), (Object)new Integer(1));
        UserResource r = (UserResource)returnedUsers.getResources().get(0);
        service.retrieve((ScimResource)r);
    }

    @Test
    public void testGetUsersUsingPost() throws ScimException {
        ListResponse returnedUsers = ((SearchRequestBuilder)new ScimService(this.target()).searchRequest("Users").filter("meta.resourceType eq \"User\"").page(1, 10).sort("id", SortOrder.DESCENDING).excludedAttributes(new String[]{"addresses", "phoneNumbers"})).invokePost(UserResource.class);
        Assert.assertEquals((long)returnedUsers.getTotalResults(), (long)1L);
        Assert.assertEquals((Object)returnedUsers.getStartIndex(), (Object)new Integer(1));
        Assert.assertEquals((Object)returnedUsers.getItemsPerPage(), (Object)new Integer(1));
        WebTarget target = (WebTarget)this.target().register((Object)new JacksonJsonProvider(JsonUtils.createObjectMapper()));
        HashSet<String> excludedAttributes = new HashSet<String>();
        excludedAttributes.add("addresses");
        excludedAttributes.add("phoneNumbers");
        SearchRequest searchRequest = new SearchRequest(null, excludedAttributes, "meta.resourceType eq \"User\"", "id", SortOrder.DESCENDING, Integer.valueOf(1), Integer.valueOf(10));
        Response response = target.path("Users").path(".search").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE, ServerUtils.MEDIA_TYPE_SCIM_TYPE}).post(Entity.json((Object)searchRequest));
        Assert.assertEquals((int)response.getStatus(), (int)200);
        Assert.assertEquals((Object)response.getMediaType(), (Object)MediaType.APPLICATION_JSON_TYPE);
        response.close();
        response = target.path("Users").path(".search").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE, ServerUtils.MEDIA_TYPE_SCIM_TYPE}).post(Entity.entity((Object)searchRequest, (String)"application/json; charset=UTF-8"));
        Assert.assertEquals((int)response.getStatus(), (int)200);
        Assert.assertEquals((Object)response.getMediaType(), (Object)MediaType.APPLICATION_JSON_TYPE);
        response.close();
        response = target.path("Users").path(".search").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE, ServerUtils.MEDIA_TYPE_SCIM_TYPE}).post(Entity.text((Object)"bad"));
        Assert.assertEquals((int)response.getStatus(), (int)415);
        Assert.assertEquals((Object)response.getMediaType(), (Object)MediaType.APPLICATION_JSON_TYPE);
        response.close();
        response = target.path("Users").path(".search").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE, ServerUtils.MEDIA_TYPE_SCIM_TYPE}).post(Entity.json(null));
        Assert.assertEquals((int)response.getStatus(), (int)400);
        Assert.assertEquals((Object)response.getMediaType(), (Object)MediaType.APPLICATION_JSON_TYPE);
        response.close();
    }

    @Test
    public void testGetMe() throws ScimException {
        ScimService scimService = new ScimService(this.target());
        UserResource user = (UserResource)scimService.retrieve(ScimService.ME_URI, UserResource.class);
        Assert.assertEquals((String)user.getId(), (String)"123");
        Assert.assertEquals((String)user.getMeta().getResourceType(), (String)"User");
        UriBuilder subResourceUri = UriBuilder.fromUri((URI)ScimService.ME_URI).path("something");
        try {
            scimService.retrieve(subResourceUri.build(new Object[0]), UserResource.class);
            Assert.fail((String)"Sub-resource should not exist");
        }
        catch (ScimException scimException) {
            // empty catch block
        }
    }

    @Test
    public void testGetMe_includedAndExcludedAttributes() throws ScimException {
        ScimService scimService = new ScimService(this.target());
        UserResource user = (UserResource)scimService.retrieve(ScimService.ME_URI, UserResource.class);
        Assert.assertEquals((String)user.getId(), (String)"123");
        Assert.assertEquals((String)user.getMeta().getResourceType(), (String)"User");
        Assert.assertEquals((String)user.getDisplayName(), (String)"UserDisplayName");
        Assert.assertEquals((String)user.getNickName(), (String)"UserNickName");
        user = (UserResource)((RetrieveRequestBuilder.Typed)scimService.retrieveRequest(ScimService.ME_URI).excludedAttributes(new String[]{"nickName"})).invoke(UserResource.class);
        Assert.assertEquals((String)user.getId(), (String)"123");
        Assert.assertEquals((String)user.getMeta().getResourceType(), (String)"User");
        Assert.assertEquals((String)user.getDisplayName(), (String)"UserDisplayName");
        Assert.assertNull((Object)user.getNickName());
        user = (UserResource)((RetrieveRequestBuilder.Typed)scimService.retrieveRequest(ScimService.ME_URI).attributes(new String[]{"nickName", "Meta"})).invoke(UserResource.class);
        Assert.assertEquals((String)user.getId(), (String)"123");
        Assert.assertEquals((String)user.getMeta().getResourceType(), (String)"User");
        Assert.assertNull((Object)user.getDisplayName());
        Assert.assertEquals((String)user.getNickName(), (String)"UserNickName");
    }

    @Test
    public void testCreate() throws ScimException {
        ScimService scimService = new ScimService(this.target());
        UserResource newUser = new UserResource().setUserName("createUser");
        EnterpriseUserExtension extension = new EnterpriseUserExtension().setEmployeeNumber("1234");
        newUser.replaceExtensionValue(Path.root(EnterpriseUserExtension.class), JsonUtils.valueToNode((Object)extension));
        UserResource createdUser = (UserResource)scimService.create("SingletonUsers", (ScimResource)newUser);
        Assert.assertNotNull((Object)createdUser.getId());
        Assert.assertEquals((String)createdUser.getUserName(), (String)newUser.getUserName());
        try {
            Assert.assertEquals((Object)JsonUtils.nodeToValue((JsonNode)((JsonNode)createdUser.getExtensionValues(Path.root(EnterpriseUserExtension.class)).get(0)), EnterpriseUserExtension.class), (Object)extension);
            Assert.assertEquals((String)((JsonNode)createdUser.getExtensionValues(Path.root(EnterpriseUserExtension.class).attribute("employeeNumber")).get(0)).textValue(), (String)"1234");
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        UserResource retrievedUser = (UserResource)scimService.retrieve((ScimResource)createdUser);
        Assert.assertEquals((Object)createdUser, (Object)retrievedUser);
    }

    @Test
    public void testDelete() throws ScimException {
        ScimService scimService = new ScimService(this.target());
        UserResource newUser = new UserResource().setUserName("deleteUser");
        UserResource createdUser = (UserResource)scimService.create("SingletonUsers", (ScimResource)newUser);
        Assert.assertNotNull((Object)createdUser.getId());
        Assert.assertEquals((String)createdUser.getUserName(), (String)newUser.getUserName());
        scimService.delete((ScimResource)createdUser);
        try {
            scimService.retrieve((ScimResource)createdUser);
            Assert.fail((String)"Resource should have been deleted");
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        WebTarget target = (WebTarget)this.target().register((Object)new JacksonJsonProvider(JsonUtils.createObjectMapper()));
        Response response = target.path("SingletonUsers").path("deleteUser").request().delete();
        Assert.assertEquals((int)response.getStatus(), (int)404);
        Assert.assertEquals((Object)response.getMediaType(), (Object)ServerUtils.MEDIA_TYPE_SCIM_TYPE);
        target = (WebTarget)this.target().register((Object)new JacksonJsonProvider(JsonUtils.createObjectMapper()));
        response = target.path("SingletonUsers").path("deleteUser").request().accept(new MediaType[]{MediaType.APPLICATION_ATOM_XML_TYPE}).delete();
        Assert.assertEquals((int)response.getStatus(), (int)404);
        Assert.assertEquals((Object)response.getMediaType(), (Object)ServerUtils.MEDIA_TYPE_SCIM_TYPE);
    }

    @Test
    public void testPut() throws ScimException {
        ScimService scimService = new ScimService(this.target());
        UserResource newUser = new UserResource().setUserName("putUser");
        UserResource createdUser = (UserResource)scimService.create("SingletonUsers", (ScimResource)newUser);
        Assert.assertNull((Object)createdUser.getDisplayName());
        createdUser.setDisplayName("Bob");
        UserResource updatedUser = (UserResource)scimService.replace((ScimResource)createdUser);
        Assert.assertEquals((String)updatedUser.getDisplayName(), (String)"Bob");
    }

    @Test
    public void testPatch() throws ScimException {
        ScimService scimService = new ScimService(this.target());
        UserResource newUser = new UserResource().setUserName("patchUser");
        newUser.setDisplayName("removeMe");
        newUser.setName(new Name().setGivenName("Bob").setFamilyName("Tester"));
        newUser.setEmails(Collections.singletonList(new Email().setValue("bob@tester.com").setType("work")));
        UserResource createdUser = (UserResource)scimService.create("SingletonUsers", (ScimResource)newUser);
        PhoneNumber phone1 = new PhoneNumber().setValue("1234567890").setType("home");
        PhoneNumber phone2 = new PhoneNumber().setValue("123123123").setType("work").setPrimary(Boolean.valueOf(true));
        UserResource updatedUser = (UserResource)((ModifyRequestBuilder.Generic)((ModifyRequestBuilder.Generic)((ModifyRequestBuilder.Generic)((ModifyRequestBuilder.Generic)scimService.modifyRequest((ScimResource)createdUser).removeValues("displayName")).replaceValue("name.middleName", (Object)"the")).replaceValue("emails[type eq \"work\"].value", (Object)"bobNew@tester.com")).addValues("phoneNumbers", new Object[]{phone1, phone2})).invoke();
        Assert.assertNull((Object)updatedUser.getDisplayName());
        Assert.assertEquals((String)updatedUser.getName().getMiddleName(), (String)"the");
        Assert.assertEquals((String)((Email)updatedUser.getEmails().get(0)).getValue(), (String)"bobNew@tester.com");
        Assert.assertEquals((int)updatedUser.getPhoneNumbers().size(), (int)2);
        Assert.assertTrue((boolean)this.contains(updatedUser.getPhoneNumbers(), phone1));
        Assert.assertTrue((boolean)this.contains(updatedUser.getPhoneNumbers(), phone2));
    }

    @Test
    public void testPatchThroughScimInterface_resource() throws ScimException {
        ScimService scimInterface = new ScimService(this.target());
        UserResource newUser = new UserResource().setUserName("patchUser");
        newUser.setDisplayName("removeMe");
        newUser.setName(new Name().setGivenName("Bob").setFamilyName("Tester"));
        newUser.setEmails(Collections.singletonList(new Email().setValue("bob@tester.com").setType("work")));
        UserResource createdUser = (UserResource)scimInterface.create("SingletonUsers", (ScimResource)newUser);
        PhoneNumber phone1 = new PhoneNumber().setValue("1234567890").setType("home");
        PhoneNumber phone2 = new PhoneNumber().setValue("123123123").setType("work").setPrimary(Boolean.valueOf(true));
        ArrayList<PatchOperation> patchOperations = new ArrayList<PatchOperation>();
        patchOperations.add(PatchOperation.remove((String)"displayName"));
        patchOperations.add(PatchOperation.replace((String)"name.middleName", (String)"the"));
        patchOperations.add(PatchOperation.replace((String)"emails[type eq \"work\"].value", (String)"bobNew@tester.com"));
        patchOperations.add(PatchOperation.add((String)"phoneNumbers", (JsonNode)JsonUtils.valueToNode((Object)Lists.newArrayList((Object[])new PhoneNumber[]{phone1, phone2}))));
        UserResource updatedUser = (UserResource)scimInterface.modify((ScimResource)createdUser, new PatchRequest(patchOperations));
        Assert.assertNull((Object)updatedUser.getDisplayName());
        Assert.assertEquals((String)updatedUser.getName().getMiddleName(), (String)"the");
        Assert.assertEquals((String)((Email)updatedUser.getEmails().get(0)).getValue(), (String)"bobNew@tester.com");
        Assert.assertEquals((int)updatedUser.getPhoneNumbers().size(), (int)2);
        Assert.assertTrue((boolean)this.contains(updatedUser.getPhoneNumbers(), phone1));
        Assert.assertTrue((boolean)this.contains(updatedUser.getPhoneNumbers(), phone2));
    }

    @Test
    public void testPatchThroughScimInterface_typeId() throws ScimException {
        ScimService scimInterface = new ScimService(this.target());
        UserResource newUser = new UserResource().setUserName("patchUser");
        newUser.setDisplayName("removeMe");
        newUser.setName(new Name().setGivenName("Bob").setFamilyName("Tester"));
        newUser.setEmails(Collections.singletonList(new Email().setValue("bob@tester.com").setType("work")));
        UserResource createdUser = (UserResource)scimInterface.create("SingletonUsers", (ScimResource)newUser);
        PhoneNumber phone1 = new PhoneNumber().setValue("1234567890").setType("home");
        PhoneNumber phone2 = new PhoneNumber().setValue("123123123").setType("work").setPrimary(Boolean.valueOf(true));
        ArrayList<PatchOperation> patchOperations = new ArrayList<PatchOperation>();
        patchOperations.add(PatchOperation.remove((String)"displayName"));
        patchOperations.add(PatchOperation.replace((String)"name.middleName", (String)"the"));
        patchOperations.add(PatchOperation.replace((String)"emails[type eq \"work\"].value", (String)"bobNew@tester.com"));
        patchOperations.add(PatchOperation.add((String)"phoneNumbers", (JsonNode)JsonUtils.valueToNode((Object)Lists.newArrayList((Object[])new PhoneNumber[]{phone1, phone2}))));
        UserResource updatedUser = (UserResource)scimInterface.modify("SingletonUsers", createdUser.getId(), new PatchRequest(patchOperations), UserResource.class);
        Assert.assertNull((Object)updatedUser.getDisplayName());
        Assert.assertEquals((String)updatedUser.getName().getMiddleName(), (String)"the");
        Assert.assertEquals((String)((Email)updatedUser.getEmails().get(0)).getValue(), (String)"bobNew@tester.com");
        Assert.assertEquals((int)updatedUser.getPhoneNumbers().size(), (int)2);
        Assert.assertTrue((boolean)this.contains(updatedUser.getPhoneNumbers(), phone1));
        Assert.assertTrue((boolean)this.contains(updatedUser.getPhoneNumbers(), phone2));
    }

    @Test
    public void testInvalidJson() throws ScimException {
        WebTarget target = (WebTarget)this.target().register((Object)new JacksonJsonProvider(JsonUtils.createObjectMapper()));
        Response response = target.path("SingletonUsers").request().accept(new String[]{"application/scim+json"}).post(Entity.entity((Object)"{badJson}", (String)"application/scim+json"));
        Assert.assertEquals((int)response.getStatus(), (int)400);
        Assert.assertEquals((Object)response.getMediaType(), (Object)MediaType.valueOf((String)"application/scim+json"));
        ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
        Assert.assertEquals((Object)errorResponse.getStatus(), (Object)new Integer(400));
        Assert.assertEquals((String)errorResponse.getScimType(), (String)"invalidSyntax");
        Assert.assertNotNull((Object)errorResponse.getDetail());
        response = target.path("SingletonUsers").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE, ServerUtils.MEDIA_TYPE_SCIM_TYPE}).post(Entity.entity((Object)"{badJson}", (MediaType)MediaType.APPLICATION_JSON_TYPE));
        Assert.assertEquals((int)response.getStatus(), (int)400);
        Assert.assertEquals((Object)response.getMediaType(), (Object)MediaType.APPLICATION_JSON_TYPE);
    }

    @Test
    public void testInvalidMessage() throws ScimException {
        WebTarget target = (WebTarget)this.target().register((Object)new JacksonJsonProvider(JsonUtils.createObjectMapper()));
        Response response = target.path("SingletonUsers").path(".search").request().accept(new String[]{"application/scim+json"}).post(Entity.entity((Object)"{\"undefinedField\": \"value\"}", (String)"application/scim+json"));
        Assert.assertEquals((int)response.getStatus(), (int)400);
        Assert.assertEquals((Object)response.getMediaType(), (Object)MediaType.valueOf((String)"application/scim+json"));
        ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
        Assert.assertEquals((Object)errorResponse.getStatus(), (Object)new Integer(400));
        Assert.assertEquals((String)errorResponse.getScimType(), (String)"invalidSyntax");
        Assert.assertNotNull((Object)errorResponse.getDetail());
        response = target.path("SingletonUsers").path(".search").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE, ServerUtils.MEDIA_TYPE_SCIM_TYPE}).post(Entity.entity((Object)"{\"undefinedField\": \"value\"}", (MediaType)MediaType.APPLICATION_JSON_TYPE));
        Assert.assertEquals((int)response.getStatus(), (int)400);
        Assert.assertEquals((Object)response.getMediaType(), (Object)MediaType.APPLICATION_JSON_TYPE);
    }

    @Test
    public void testEmptyEntity() throws ScimException {
        WebTarget target = (WebTarget)this.target().register((Object)new JacksonJsonProvider(JsonUtils.createObjectMapper()));
        Invocation.Builder b = target.path("SingletonUsers").request(new String[]{"application/scim+json"});
        Response response = b.build("POST").invoke();
        Assert.assertEquals((int)response.getStatus(), (int)400);
        ErrorResponse error = (ErrorResponse)response.readEntity(ErrorResponse.class);
        Assert.assertTrue((boolean)error.getDetail().contains("No content provided"));
        response.close();
        b = target.path("SingletonUsers").path("123").request(new String[]{"application/scim+json"});
        response = b.build("PATCH").invoke();
        Assert.assertEquals((int)response.getStatus(), (int)400);
        Assert.assertEquals((Object)response.getMediaType(), (Object)ServerUtils.MEDIA_TYPE_SCIM_TYPE);
        error = (ErrorResponse)response.readEntity(ErrorResponse.class);
        Assert.assertTrue((boolean)error.getDetail().contains("No content provided"));
        response.close();
        b = target.path("SingletonUsers").request(new String[]{"application/scim+json"}).header("Content-Type", (Object)"application/scim+json");
        response = b.build("POST").invoke();
        Assert.assertEquals((int)response.getStatus(), (int)400);
        Assert.assertEquals((Object)response.getMediaType(), (Object)ServerUtils.MEDIA_TYPE_SCIM_TYPE);
        error = (ErrorResponse)response.readEntity(ErrorResponse.class);
        Assert.assertTrue((boolean)error.getDetail().contains("No content provided"));
        response.close();
        b = target.path("SingletonUsers").path("123").request(new String[]{"application/scim+json"}).header("Content-Type", (Object)"application/scim+json");
        response = b.build("PATCH").invoke();
        Assert.assertEquals((int)response.getStatus(), (int)400);
        Assert.assertEquals((Object)response.getMediaType(), (Object)ServerUtils.MEDIA_TYPE_SCIM_TYPE);
        error = (ErrorResponse)response.readEntity(ErrorResponse.class);
        Assert.assertTrue((boolean)error.getDetail().contains("No content provided"));
        response.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryParams() throws ScimException {
        ScimService service = new ScimService(this.target());
        String expectedKey = "expectedKey";
        String expectedValue = "expectedValue";
        this.requestFilter.addExpectedQueryParam("expectedKey", "expectedValue");
        try {
            try {
                ((RetrieveRequestBuilder.Typed)service.retrieveRequest(ScimService.ME_URI).queryParam("expectedKey", new Object[]{"unexpectedValue"})).invoke(UserResource.class);
                Assert.fail((String)"Expected BadRequestException");
            }
            catch (BadRequestException badRequestException) {
                // empty catch block
            }
            ((RetrieveRequestBuilder.Typed)service.retrieveRequest(ScimService.ME_URI).queryParam("expectedKey", new Object[]{"expectedValue"})).invoke(UserResource.class);
            UserResource newUser = new UserResource().setUserName("queryParamUser");
            UserResource createdUser = (UserResource)((CreateRequestBuilder)service.createRequest("SingletonUsers", (ScimResource)newUser).queryParam("expectedKey", new Object[]{"expectedValue"})).invoke();
            createdUser.setDisplayName("Bob");
            UserResource updatedUser = (UserResource)((ReplaceRequestBuilder)service.replaceRequest((ScimResource)createdUser).queryParam("expectedKey", new Object[]{"expectedValue"})).invoke();
            UserResource patchedUser = (UserResource)((ModifyRequestBuilder.Typed)((ModifyRequestBuilder.Typed)service.modifyRequest("SingletonUsers", updatedUser.getId()).addOperation(PatchOperation.replace((String)"displayName", (JsonNode)TextNode.valueOf((String)"Joe")))).queryParam("expectedKey", new Object[]{"expectedValue"})).invoke(UserResource.class);
            ((DeleteRequestBuilder)service.deleteRequest("SingletonUsers", patchedUser.getId()).queryParam("expectedKey", new Object[]{"expectedValue"})).invoke();
            String filter = "meta.resourceType eq \"User\"";
            this.requestFilter.addExpectedQueryParam("filter", filter);
            ((SearchRequestBuilder)service.searchRequest("Users").filter(filter).queryParam("expectedKey", new Object[]{"expectedValue"})).invoke(UserResource.class);
            this.requestFilter.reset();
            this.requestFilter.addExpectedQueryParam("expectedKey", "expectedValue1");
            this.requestFilter.addExpectedQueryParam("expectedKey", "expectedValue2");
            ((RetrieveRequestBuilder.Typed)((RetrieveRequestBuilder.Typed)service.retrieveRequest(ScimService.ME_URI).queryParam("expectedKey", new Object[]{"expectedValue1"})).queryParam("expectedKey", new Object[]{"expectedValue2"})).invoke(UserResource.class);
        }
        finally {
            this.requestFilter.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeaders() throws ScimException {
        ScimService service = new ScimService(this.target());
        String expectedKey = "expectedKey";
        String expectedValue = "expectedValue";
        this.requestFilter.addExpectedHeader("expectedKey", "expectedValue");
        this.requestFilter.addExpectedHeader("Accept", ScimService.MEDIA_TYPE_SCIM_TYPE.toString());
        this.requestFilter.addExpectedHeader("Accept", MediaType.APPLICATION_JSON_TYPE.toString());
        try {
            try {
                ((RetrieveRequestBuilder.Typed)service.retrieveRequest(ScimService.ME_URI).header("expectedKey", new Object[]{"unexpectedValue"})).invoke(UserResource.class);
                Assert.fail((String)"Expected BadRequestException");
            }
            catch (BadRequestException badRequestException) {
                // empty catch block
            }
            ((RetrieveRequestBuilder.Typed)service.retrieveRequest(ScimService.ME_URI).header("expectedKey", new Object[]{"expectedValue"})).invoke(UserResource.class);
            UserResource newUser = new UserResource().setUserName("queryParamUser");
            UserResource createdUser = (UserResource)((CreateRequestBuilder)service.createRequest("SingletonUsers", (ScimResource)newUser).header("expectedKey", new Object[]{"expectedValue"})).invoke();
            createdUser.setDisplayName("Bob");
            UserResource updatedUser = (UserResource)((ReplaceRequestBuilder)service.replaceRequest((ScimResource)createdUser).header("expectedKey", new Object[]{"expectedValue"})).invoke();
            UserResource patchedUser = (UserResource)((ModifyRequestBuilder.Typed)((ModifyRequestBuilder.Typed)service.modifyRequest("SingletonUsers", updatedUser.getId()).addOperation(PatchOperation.replace((String)"displayName", (JsonNode)TextNode.valueOf((String)"Joe")))).header("expectedKey", new Object[]{"expectedValue"})).invoke(UserResource.class);
            ((DeleteRequestBuilder)service.deleteRequest("SingletonUsers", patchedUser.getId()).header("expectedKey", new Object[]{"expectedValue"})).invoke();
            ((SearchRequestBuilder)service.searchRequest("Users").filter("meta.resourceType eq \"User\"").header("expectedKey", new Object[]{"expectedValue"})).invoke(UserResource.class);
            ((SearchRequestBuilder)service.searchRequest("Users").filter("meta.resourceType eq \"User\"").header("expectedKey", new Object[]{"expectedValue"})).invokePost(UserResource.class);
            this.requestFilter.reset();
            this.requestFilter.addExpectedHeader("expectedKey", "expectedValue1");
            this.requestFilter.addExpectedHeader("expectedKey", "expectedValue2");
            ((RetrieveRequestBuilder.Typed)((RetrieveRequestBuilder.Typed)service.retrieveRequest(ScimService.ME_URI).header("expectedKey", new Object[]{"expectedValue1"})).header("expectedKey", new Object[]{"expectedValue2"})).invoke(UserResource.class);
        }
        finally {
            this.requestFilter.reset();
        }
    }

    @Test
    public void testMetaIsReturnedByDefaultOnly() throws Exception {
        ScimService scimService = new ScimService(this.target());
        UserResource user = (UserResource)((RetrieveRequestBuilder.Typed)scimService.retrieveRequest(ScimService.ME_URI).attributes(new String[]{"nickName"})).invoke(UserResource.class);
        Assert.assertNull((Object)user.getMeta());
        user = (UserResource)((RetrieveRequestBuilder.Typed)scimService.retrieveRequest(ScimService.ME_URI).excludedAttributes(new String[]{"meta"})).invoke(UserResource.class);
        Assert.assertNull((Object)user.getMeta());
        user = (UserResource)scimService.retrieveRequest(ScimService.ME_URI).invoke(UserResource.class);
        Assert.assertNotNull((Object)user.getMeta());
        Assert.assertNotNull((Object)user.getMeta().getLocation());
        Assert.assertNotNull((Object)user.getMeta().getResourceType());
    }

    @Test
    public void testBadErrorResult() throws Exception {
        ScimService service = new ScimService(this.target());
        try {
            service.create("Users/badException", (ScimResource)new GenericScimResource());
            Assert.fail((String)"Expecting a ScimServiceException");
        }
        catch (ScimServiceException ex) {
            ErrorResponse response = ex.getScimError();
            Assert.assertEquals((Object)response.getStatus(), (Object)409);
            Assert.assertNotNull((Object)ex.getCause());
        }
    }

    @Test
    public void testMethodNotAllowed() throws ScimException {
        ScimService service = new ScimService(this.target());
        try {
            service.create("Users/schema", (ScimResource)new GenericScimResource());
            Assert.fail((String)"Expecting a MethodNotFoundException");
        }
        catch (MethodNotAllowedException ex) {
            ErrorResponse response = ex.getScimError();
            Assert.assertEquals((Object)response.getStatus(), (Object)405);
            Assert.assertTrue((boolean)response.getDetail().contains("Method Not Allowed"));
        }
    }

    @Test
    public void testCustomContentType() throws ScimException {
        ScimService scimService = new ScimService(this.target());
        UserResource newUser = new UserResource().setUserName("putUser");
        newUser.setDisplayName("removeMe");
        UserResource createdUser = (UserResource)((CreateRequestBuilder)scimService.createRequest("CustomContent", (ScimResource)newUser).contentType("application/json")).invoke();
        Assert.assertNotNull((Object)createdUser);
        UserResource replacedUser = (UserResource)((ReplaceRequestBuilder)scimService.replaceRequest((ScimResource)createdUser).contentType("application/json")).invoke();
        Assert.assertNotNull((Object)replacedUser);
        ((ModifyRequestBuilder.Generic)((ModifyRequestBuilder.Generic)scimService.modifyRequest((ScimResource)replacedUser).removeValues("displayName")).contentType("application/json")).invoke();
        String returnString = new String((byte[])((RetrieveRequestBuilder.Typed)scimService.retrieveRequest("CustomContent", "123").accept(new String[]{"application/octet-stream"})).invoke(byte[].class));
        Assert.assertNotNull((Object)returnString);
    }

    @Test
    public void testAcceptExceptions() throws ScimException {
        String returnString2;
        ScimService scimService = new ScimService(this.target());
        try {
            returnString2 = new String((byte[])((RetrieveRequestBuilder.Typed)scimService.retrieveRequest("CustomContent", "123").accept(null)).invoke(byte[].class));
            Assert.fail((String)"Expected illegal argument exception");
        }
        catch (IllegalArgumentException returnString2) {
            // empty catch block
        }
        try {
            returnString2 = new String((byte[])((RetrieveRequestBuilder.Typed)scimService.retrieveRequest("CustomContent", "123").accept(new String[0])).invoke(byte[].class));
            Assert.fail((String)"Expected illegal argument exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void setMeta(Class<?> resourceClass, ScimResource scimResource) {
        Meta meta;
        ResourceTypeResource resourceType = ResourceTypeDefinition.fromJaxRsResource(resourceClass).toScimResource();
        UriBuilder locationBuilder = UriBuilder.fromUri((URI)this.getBaseUri()).path(resourceType.getEndpoint().getPath());
        if (scimResource.getId() != null) {
            locationBuilder.path(scimResource.getId());
        }
        if ((meta = scimResource.getMeta()) == null) {
            meta = new Meta();
            scimResource.setMeta(meta);
        }
        meta.setLocation(locationBuilder.build(new Object[0]));
        meta.setResourceType(resourceType.getName());
    }

    private <T> boolean contains(Iterable<T> list, T resource) {
        for (T r : list) {
            if (!r.equals(resource)) continue;
            return true;
        }
        return false;
    }
}

