/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.unboundid.scim2.client.ScimService;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.NotModifiedException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.types.AuthenticationScheme;
import com.unboundid.scim2.common.types.BulkConfig;
import com.unboundid.scim2.common.types.ChangePasswordConfig;
import com.unboundid.scim2.common.types.ETagConfig;
import com.unboundid.scim2.common.types.FilterConfig;
import com.unboundid.scim2.common.types.Meta;
import com.unboundid.scim2.common.types.PatchConfig;
import com.unboundid.scim2.common.types.ServiceProviderConfigResource;
import com.unboundid.scim2.common.types.SortConfig;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.server.ETagTestEndpoint;
import com.unboundid.scim2.server.TestSingletonResourceEndpoint;
import com.unboundid.scim2.server.providers.JsonProcessingExceptionMapper;
import com.unboundid.scim2.server.providers.RuntimeExceptionMapper;
import com.unboundid.scim2.server.providers.ScimExceptionMapper;
import com.unboundid.scim2.server.resources.AbstractServiceProviderConfigEndpoint;
import com.unboundid.scim2.server.resources.ResourceTypesEndpoint;
import com.unboundid.scim2.server.resources.SchemasEndpoint;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.test.JerseyTestNg;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ETagTestCase
extends JerseyTestNg.ContainerPerClassTest {
    private static final URI ETAG_URI = URI.create("etag/test");

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register(ScimExceptionMapper.class);
        config.register(RuntimeExceptionMapper.class);
        config.register(JsonProcessingExceptionMapper.class);
        config.register((Object)new JacksonJsonProvider(JsonUtils.createObjectMapper()));
        config.register(ResourceTypesEndpoint.class);
        config.register(SchemasEndpoint.class);
        this.registerAdditionalConfigItems(config);
        config.register(ETagTestEndpoint.class);
        config.register((Object)new TestSingletonResourceEndpoint());
        return config;
    }

    protected void registerAdditionalConfigItems(ResourceConfig config) {
        config.register((Object)new AbstractServiceProviderConfigEndpoint(){

            public ServiceProviderConfigResource getServiceProviderConfig() throws ScimException {
                return new ServiceProviderConfigResource("https://doc", new PatchConfig(true), new BulkConfig(true, 100, 1000), new FilterConfig(true, 200), new ChangePasswordConfig(true), new SortConfig(true), new ETagConfig(true), Collections.singletonList(new AuthenticationScheme("Basic", "HTTP BASIC", null, null, "httpbasic", true)));
            }
        });
    }

    protected void configureClient(ClientConfig config) {
        config.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
    }

    @Test
    public void testIfNoneMatch_retrieve() throws ScimException {
        ScimService scimService = new ScimService(this.target());
        GenericScimResource gsr = new GenericScimResource();
        Meta meta = new Meta();
        meta.setLocation(UriBuilder.fromUri((URI)ETAG_URI).path("/123").build(new Object[0]));
        meta.setVersion("123");
        gsr.setMeta(meta);
        this.verifyEtagHeaders((GenericScimResource)scimService.retrieveRequest(ETAG_URI).invoke(GenericScimResource.class), false, false);
        this.verifyEtagHeaders((GenericScimResource)scimService.retrieveRequest(ETAG_URI).ifNoneMatch("123").invoke(GenericScimResource.class), false, true);
        this.verifyEtagHeaders((GenericScimResource)scimService.retrieveRequest(ETAG_URI.toString(), "123").invoke(GenericScimResource.class), false, false);
        this.verifyEtagHeaders((GenericScimResource)scimService.retrieveRequest(ETAG_URI.toString(), "123").ifNoneMatch("123").invoke(GenericScimResource.class), false, true);
        this.verifyEtagHeaders((GenericScimResource)scimService.retrieveRequest((ScimResource)gsr).invoke(GenericScimResource.class), false, false);
        this.verifyEtagHeaders((GenericScimResource)scimService.retrieveRequest((ScimResource)gsr).ifNoneMatch().invoke(GenericScimResource.class), false, true);
        this.verifyEtagHeaders((GenericScimResource)scimService.retrieve(ETAG_URI, GenericScimResource.class), false, false);
        this.verifyEtagHeaders((GenericScimResource)scimService.retrieve(ETAG_URI.toString(), "123", GenericScimResource.class), false, false);
        this.verifyEtagHeaders((GenericScimResource)scimService.retrieve((ScimResource)gsr), false, false);
    }

    @Test(expectedExceptions={NotModifiedException.class})
    public void testIfNoneMatch_retrieveException() throws ScimException {
        ScimService scimService = new ScimService(this.target());
        GenericScimResource gsr = new GenericScimResource();
        Meta meta = new Meta();
        meta.setLocation(UriBuilder.fromUri((URI)ETAG_URI).path("/123").build(new Object[0]));
        meta.setVersion("123");
        gsr.setMeta(meta);
        scimService.retrieveRequest(UriBuilder.fromUri((URI)ETAG_URI).path("/exception/notModified").build(new Object[0])).ifNoneMatch("123").invoke(GenericScimResource.class);
    }

    @Test
    public void testIfMatch_modify() throws ScimException {
        ScimService scimService = new ScimService(this.target());
        GenericScimResource gsr = new GenericScimResource();
        Meta meta = new Meta();
        meta.setLocation(UriBuilder.fromUri((URI)ETAG_URI).path("/123").build(new Object[0]));
        meta.setVersion("123");
        gsr.setMeta(meta);
        this.verifyEtagHeaders((GenericScimResource)scimService.modifyRequest(ETAG_URI).invoke(GenericScimResource.class), false, false);
        this.verifyEtagHeaders((GenericScimResource)scimService.modifyRequest(ETAG_URI).ifMatch("123").invoke(GenericScimResource.class), true, false);
        this.verifyEtagHeaders((GenericScimResource)scimService.modifyRequest(ETAG_URI.toString(), "123").invoke(GenericScimResource.class), false, false);
        this.verifyEtagHeaders((GenericScimResource)scimService.modifyRequest(ETAG_URI.toString(), "123").ifMatch("123").invoke(GenericScimResource.class), true, false);
        this.verifyEtagHeaders((GenericScimResource)scimService.modifyRequest((ScimResource)gsr).invoke(GenericScimResource.class), false, false);
        this.verifyEtagHeaders((GenericScimResource)scimService.modifyRequest((ScimResource)gsr).ifMatch().invoke(GenericScimResource.class), true, false);
        PatchRequest patchRequest = new PatchRequest(Collections.emptyList());
        this.verifyEtagHeaders((GenericScimResource)scimService.modify(ETAG_URI.toString(), "123", patchRequest, GenericScimResource.class), false, false);
        this.verifyEtagHeaders((GenericScimResource)scimService.modify((ScimResource)gsr, patchRequest), false, false);
    }

    @Test
    public void testIfMatch_replace() throws ScimException {
        ScimService scimService = new ScimService(this.target());
        GenericScimResource gsr = new GenericScimResource();
        Meta meta = new Meta();
        meta.setLocation(UriBuilder.fromUri((URI)ETAG_URI).path("/123").build(new Object[0]));
        meta.setVersion("123");
        gsr.setMeta(meta);
        this.verifyEtagHeaders((GenericScimResource)scimService.replaceRequest(ETAG_URI, (ScimResource)gsr).invoke(GenericScimResource.class), false, false);
        this.verifyEtagHeaders((GenericScimResource)scimService.replaceRequest(ETAG_URI, (ScimResource)gsr).ifMatch().invoke(GenericScimResource.class), true, false);
        this.verifyEtagHeaders((GenericScimResource)scimService.replaceRequest((ScimResource)gsr).invoke(GenericScimResource.class), false, false);
        this.verifyEtagHeaders((GenericScimResource)scimService.replaceRequest((ScimResource)gsr).ifMatch().invoke(GenericScimResource.class), true, false);
        this.verifyEtagHeaders((GenericScimResource)scimService.replace((ScimResource)gsr), false, false);
    }

    @Test
    public void testIfMatch_delete() throws ScimException {
        ScimService scimService = new ScimService(this.target());
        GenericScimResource gsr = new GenericScimResource();
        Meta meta = new Meta();
        meta.setLocation(UriBuilder.fromUri((URI)ETAG_URI).path("/123").build(new Object[0]));
        meta.setVersion("123");
        gsr.setMeta(meta);
        scimService.deleteRequest(ETAG_URI).invoke();
        this.verifyEtagHeaders(ETagTestEndpoint.lastResult, false, false);
        scimService.deleteRequest(ETAG_URI).ifMatch("123").invoke();
        this.verifyEtagHeaders(ETagTestEndpoint.lastResult, true, false);
        scimService.deleteRequest(ETAG_URI.toString(), "123").invoke();
        this.verifyEtagHeaders(ETagTestEndpoint.lastResult, false, false);
        scimService.deleteRequest(ETAG_URI.toString(), "123").ifMatch("123").invoke();
        this.verifyEtagHeaders(ETagTestEndpoint.lastResult, true, false);
        scimService.deleteRequest((ScimResource)gsr).invoke();
        this.verifyEtagHeaders(ETagTestEndpoint.lastResult, false, false);
        scimService.deleteRequest((ScimResource)gsr).ifMatch("123").invoke();
        this.verifyEtagHeaders(ETagTestEndpoint.lastResult, true, false);
        scimService.delete(ETAG_URI);
        this.verifyEtagHeaders(ETagTestEndpoint.lastResult, false, false);
        scimService.delete(ETAG_URI.toString(), "123");
        this.verifyEtagHeaders(ETagTestEndpoint.lastResult, false, false);
        scimService.delete((ScimResource)gsr);
        this.verifyEtagHeaders(ETagTestEndpoint.lastResult, false, false);
    }

    private void verifyEtagHeaders(GenericScimResource resource, boolean shouldContainIfMatch, boolean shouldContainIfNoneMatch) throws ScimException {
        if (shouldContainIfMatch) {
            List ifMatchValues = resource.getStringValueList("If-Match");
            Assert.assertNotNull((Object)ifMatchValues);
            Assert.assertFalse((boolean)ifMatchValues.isEmpty());
        } else {
            Assert.assertTrue((boolean)resource.getObjectNode().path("If-Match").isMissingNode());
        }
        if (shouldContainIfNoneMatch) {
            List ifNoneMatchValues = resource.getStringValueList("If-None-Match");
            Assert.assertNotNull((Object)ifNoneMatchValues);
            Assert.assertFalse((boolean)ifNoneMatchValues.isEmpty());
        } else {
            Assert.assertTrue((boolean)resource.getObjectNode().path("If-None-Match").isMissingNode());
        }
    }
}

