/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Parcelable;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.d;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.notification.c.b;
import com.meizu.cloud.pushsdk.notification.c.c;
import com.meizu.cloud.pushsdk.notification.model.AdvanceSetting;
import com.meizu.cloud.pushsdk.notification.model.AdvanceSettingEx;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import org.json.JSONObject;

public abstract class a
implements com.meizu.cloud.pushsdk.notification.c {
    protected final Context a;
    protected final PushNotificationBuilder b;
    private final NotificationManager c;
    private final Handler d;

    protected a(Context context, PushNotificationBuilder pushNotificationBuilder) {
        this.b = pushNotificationBuilder;
        this.a = context;
        this.d = new Handler(context.getMainLooper());
        this.c = (NotificationManager)context.getSystemService("notification");
    }

    protected void a(Notification.Builder builder, MessageV3 messageV3) {
    }

    protected void a(Notification notification, MessageV3 messageV3) {
    }

    protected void a(Notification notification, MessageV3 messageV3, PendingIntent pendingIntent) {
    }

    protected void b(Notification.Builder builder, MessageV3 messageV3) {
    }

    private Notification a(MessageV3 messageV3, PendingIntent pendingIntent, PendingIntent pendingIntent2, PendingIntent pendingIntent3) {
        Notification.Builder builder = new Notification.Builder(this.a);
        this.a(builder, messageV3, pendingIntent, pendingIntent2);
        this.c(builder, messageV3);
        this.b(builder, messageV3);
        this.a(builder, messageV3);
        this.d(builder, messageV3);
        Notification notification = MinSdkChecker.isSupportNotificationBuild() ? builder.build() : builder.getNotification();
        this.b(notification, messageV3);
        this.a(notification, messageV3);
        this.a(notification, messageV3, pendingIntent3);
        return notification;
    }

    private PendingIntent c(MessageV3 messageV3) {
        if (this.d(messageV3)) {
            return this.a(messageV3, messageV3.getPackageName(), false);
        }
        return this.a(messageV3, messageV3.getUploadDataPackageName(), true);
    }

    private boolean d(MessageV3 messageV3) {
        if (messageV3.getAdvertisementOption() != null && !TextUtils.isEmpty((CharSequence)messageV3.getAdvertisementOption().getAdPackage())) {
            return true;
        }
        return messageV3.getWhiteList() && !MzSystemUtils.isExistReceiver(this.a, messageV3.getUploadDataPackageName(), "com.meizu.flyme.push.intent.MESSAGE");
    }

    private PendingIntent a(MessageV3 messageV3, String string, boolean bl) {
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        if (bl && MinSdkChecker.isSupportTransmitMessageValue(this.a, string)) {
            intent.putExtra("messageValue", com.meizu.cloud.pushsdk.handler.d.a(messageV3));
        } else {
            intent.putExtra("pushMessage", (Parcelable)messageV3);
        }
        intent.putExtra("method", "private");
        intent.setClassName(string, MzSystemUtils.findReceiver(this.a, "com.meizu.flyme.push.intent.MESSAGE", string));
        intent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        intent.setFlags(32);
        return PendingIntent.getBroadcast((Context)this.a, (int)0, (Intent)intent, (int)0x40000000);
    }

    private PendingIntent e(MessageV3 messageV3) {
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        intent.putExtra("pushMessage", (Parcelable)messageV3);
        intent.putExtra("method", "notification_delete");
        intent.setClassName(messageV3.getPackageName(), MzSystemUtils.findReceiver(this.a, "com.meizu.flyme.push.intent.MESSAGE", messageV3.getPackageName()));
        intent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        return PendingIntent.getBroadcast((Context)this.a, (int)0, (Intent)intent, (int)0x40000000);
    }

    private PendingIntent f(MessageV3 messageV3) {
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        intent.putExtra("pushMessage", (Parcelable)messageV3);
        intent.putExtra("method", "notification_close");
        intent.setClassName(messageV3.getPackageName(), MzSystemUtils.findReceiver(this.a, "com.meizu.flyme.push.intent.MESSAGE", messageV3.getPackageName()));
        intent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        return PendingIntent.getBroadcast((Context)this.a, (int)0, (Intent)intent, (int)0x40000000);
    }

    private PendingIntent g(MessageV3 messageV3) {
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        intent.putExtra("notification_state_message", messageV3.getNotificationMessage());
        intent.putExtra("notification_extra_task_id", messageV3.getTaskId());
        intent.putExtra("notification_extra_seq_id", messageV3.getSeqId());
        intent.putExtra("notification_extra_device_id", messageV3.getDeviceId());
        intent.putExtra("notification_extra_push_timestamp", messageV3.getPushTimestamp());
        intent.putExtra("notification_extra_show_package_name", messageV3.getUploadDataPackageName());
        intent.putExtra("mz_push_white_list", messageV3.getWhiteList());
        intent.putExtra("mz_push_delayed_report_millis", messageV3.getDelayedReportMillis());
        intent.putExtra("method", "notification_state");
        String string = MzSystemUtils.findReceiver(this.a, "com.meizu.flyme.push.intent.MESSAGE", messageV3.getPackageName());
        intent.setClassName(messageV3.getPackageName(), string);
        intent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        return PendingIntent.getBroadcast((Context)this.a, (int)0, (Intent)intent, (int)0x40000000);
    }

    private void a(Notification.Builder builder, MessageV3 messageV3, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        builder.setContentTitle((CharSequence)messageV3.getTitle());
        builder.setContentText((CharSequence)messageV3.getContent());
        builder.setTicker((CharSequence)messageV3.getTitle());
        builder.setAutoCancel(true);
        if (MinSdkChecker.isSupportSendNotification()) {
            builder.setVisibility(1);
        }
        if (MinSdkChecker.isSupportSetDrawableSmallIcon()) {
            Icon icon = this.b(messageV3.getUploadDataPackageName());
            if (icon != null) {
                builder.setSmallIcon(icon);
            } else {
                DebugLogger.e("AbstractPushNotification", "cannot get " + messageV3.getUploadDataPackageName() + " smallIcon");
                builder.setSmallIcon(com.meizu.cloud.pushsdk.notification.c.c.l(this.a));
            }
        } else {
            builder.setSmallIcon(this.b != null && this.b.getStatusBarIcon() != 0 ? this.b.getStatusBarIcon() : com.meizu.cloud.pushsdk.notification.c.c.l(this.a));
        }
        builder.setContentIntent(pendingIntent);
        builder.setDeleteIntent(pendingIntent2);
    }

    private void c(Notification.Builder builder, MessageV3 messageV3) {
        boolean bl;
        AdvanceSetting advanceSetting = messageV3.getAdvanceSetting();
        AdvanceSettingEx advanceSettingEx = messageV3.getAdvanceSettingEx();
        if (advanceSetting == null) {
            return;
        }
        if (advanceSettingEx != null && !TextUtils.isEmpty((CharSequence)advanceSettingEx.getSoundTitle())) {
            Uri uri = com.meizu.cloud.pushsdk.notification.c.b.b(this.a, advanceSettingEx.getSoundTitle());
            if (uri != null) {
                DebugLogger.e("AbstractPushNotification", "advance setting builder, sound:" + uri);
                builder.setSound(uri);
                bl = false;
            } else {
                bl = true;
            }
        } else {
            bl = advanceSetting.getNotifyType().isSound();
        }
        if (advanceSetting.getNotifyType() != null) {
            boolean bl2 = advanceSetting.getNotifyType().isVibrate();
            boolean bl3 = advanceSetting.getNotifyType().isLights();
            if (bl2 || bl3 || bl) {
                int n2 = 0;
                if (bl2) {
                    n2 |= 2;
                }
                if (bl3) {
                    n2 |= 4;
                }
                if (bl) {
                    n2 |= 1;
                }
                DebugLogger.e("AbstractPushNotification", "advance setting builder, defaults:" + n2);
                builder.setDefaults(n2);
            }
        }
        DebugLogger.e("AbstractPushNotification", "advance setting builder, ongoing:" + !advanceSetting.isClearNotification());
        builder.setOngoing(!advanceSetting.isClearNotification());
        if (advanceSettingEx != null && MinSdkChecker.isSupportNotificationBuild()) {
            DebugLogger.e("AbstractPushNotification", "advance setting builder, priority:" + advanceSettingEx.getPriorityDisplay());
            builder.setPriority(advanceSettingEx.getPriorityDisplay());
        }
    }

    protected Bitmap a(String string) {
        com.meizu.cloud.pushsdk.c.a.b b2 = com.meizu.cloud.pushsdk.c.a.a(string).a();
        com.meizu.cloud.pushsdk.c.a.c c2 = b2.b();
        if (c2.b() && c2.a() != null) {
            DebugLogger.i("AbstractPushNotification", "ANRequest On other Thread down load largeIcon " + string + "image " + (c2.a() != null ? "success" : "fail"));
            return (Bitmap)c2.a();
        }
        DebugLogger.i("AbstractPushNotification", "ANRequest On other Thread down load largeIcon " + string + "image fail");
        return null;
    }

    @TargetApi(value=23)
    private Icon b(String string) {
        Icon icon = null;
        try {
            Resources resources = this.a.getPackageManager().getResourcesForApplication(string);
            int n2 = resources.getIdentifier("mz_push_notification_small_icon", "drawable", string);
            if (n2 != 0) {
                DebugLogger.i("AbstractPushNotification", "get " + string + " smallIcon success resId " + n2);
                icon = Icon.createWithResource((String)string, (int)n2);
            }
        }
        catch (Exception exception) {
            DebugLogger.e("AbstractPushNotification", "cannot load smallIcon form package " + string + " Error message " + exception.getMessage());
        }
        return icon;
    }

    protected Bitmap a(Context context, String string) {
        Bitmap bitmap = null;
        try {
            PackageManager packageManager = context.getPackageManager();
            Drawable drawable2 = packageManager.getApplicationIcon(string);
            BitmapDrawable bitmapDrawable = null;
            if (Build.VERSION.SDK_INT >= 26) {
                if (drawable2 instanceof BitmapDrawable) {
                    bitmapDrawable = (BitmapDrawable)drawable2;
                } else if (drawable2 instanceof AdaptiveIconDrawable) {
                    Bitmap bitmap2 = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas canvas = new Canvas(bitmap2);
                    drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                    drawable2.draw(canvas);
                    bitmap = bitmap2;
                }
            } else {
                bitmapDrawable = (BitmapDrawable)drawable2;
            }
            if (bitmap == null) {
                bitmap = bitmapDrawable.getBitmap();
            }
        }
        catch (Exception exception) {
            DebugLogger.i("AbstractPushNotification", "get app icon error " + exception.getMessage());
            BitmapDrawable bitmapDrawable = (BitmapDrawable)context.getApplicationInfo().loadIcon(context.getPackageManager());
            bitmap = bitmapDrawable.getBitmap();
        }
        return bitmap;
    }

    private String b(Context context, String string) {
        String string2 = null;
        try {
            CharSequence charSequence;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string, 0);
            if (applicationInfo != null && (charSequence = packageManager.getApplicationLabel(applicationInfo)) != null) {
                string2 = (String)charSequence;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            DebugLogger.e("AbstractPushNotification", "can not find " + string + " application info");
        }
        return string2;
    }

    protected boolean a() {
        return Thread.currentThread() == this.a.getMainLooper().getThread();
    }

    protected String a(MessageV3 messageV3) {
        String string = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)messageV3.getNotificationMessage())) {
                JSONObject jSONObject = new JSONObject(messageV3.getNotificationMessage());
                string = jSONObject.getJSONObject("data").getJSONObject("extra").getString("fns");
            }
        }
        catch (Exception exception) {
            DebugLogger.e("AbstractPushNotification", "parse flyme notification setting error " + exception.getMessage());
        }
        DebugLogger.i("AbstractPushNotification", "current FlymeGreen notification setting is " + string);
        return string;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void b(MessageV3 messageV3) {
        String string = null;
        if (messageV3.getAdvertisementOption() != null && !TextUtils.isEmpty((CharSequence)messageV3.getAdvertisementOption().getAdPackage())) {
            string = this.h(messageV3);
        }
        Notification notification = this.a(messageV3, this.c(messageV3), this.e(messageV3), this.f(messageV3));
        int n2 = Math.abs((int)System.currentTimeMillis());
        com.meizu.cloud.pushsdk.notification.model.a a2 = com.meizu.cloud.pushsdk.notification.model.a.a(messageV3);
        if (a2 != null && a2.a() != 0) {
            n2 = a2.a();
            DebugLogger.e("AbstractPushNotification", "server notify id " + n2);
            if (!TextUtils.isEmpty((CharSequence)a2.b())) {
                int n3 = com.meizu.cloud.pushsdk.util.b.i(this.a, messageV3.getUploadDataPackageName(), a2.b());
                DebugLogger.e("AbstractPushNotification", "notifyKey " + a2.b() + " preference notifyId is " + n3);
                if (n3 != 0) {
                    DebugLogger.e("AbstractPushNotification", "use preference notifyId " + n3 + " and cancel it");
                    this.c.cancel(n3);
                }
                DebugLogger.e("AbstractPushNotification", "store new notifyId " + n2 + " by notifyKey " + a2.b());
                com.meizu.cloud.pushsdk.util.b.b(this.a, messageV3.getUploadDataPackageName(), a2.b(), n2);
            }
        }
        DebugLogger.e("AbstractPushNotification", "current notify id " + n2);
        if (messageV3.isDiscard()) {
            if (com.meizu.cloud.pushsdk.util.b.c(this.a, messageV3.getPackageName()) == 0) {
                com.meizu.cloud.pushsdk.util.b.a(this.a, messageV3.getPackageName(), n2);
                DebugLogger.i("AbstractPushNotification", "no notification show so put notification id " + n2);
            }
            if (!TextUtils.isEmpty((CharSequence)messageV3.getTaskId())) {
                if (com.meizu.cloud.pushsdk.util.b.d(this.a, messageV3.getPackageName()) == 0) {
                    com.meizu.cloud.pushsdk.util.b.b(this.a, messageV3.getPackageName(), Integer.valueOf(messageV3.getTaskId()));
                } else {
                    if (Integer.valueOf(messageV3.getTaskId()) < com.meizu.cloud.pushsdk.util.b.d(this.a, messageV3.getPackageName())) {
                        DebugLogger.i("AbstractPushNotification", "current package " + messageV3.getPackageName() + " task id " + messageV3.getTaskId() + " don't show notification");
                        return;
                    }
                    com.meizu.cloud.pushsdk.util.b.b(this.a, messageV3.getPackageName(), Integer.valueOf(messageV3.getTaskId()));
                    n2 = com.meizu.cloud.pushsdk.util.b.c(this.a, messageV3.getPackageName());
                }
            }
            DebugLogger.i("AbstractPushNotification", "current package " + messageV3.getPackageName() + " notificationId=" + n2 + " taskId=" + messageV3.getTaskId());
        }
        if (messageV3.getAdvertisementOption() != null && !TextUtils.isEmpty((CharSequence)messageV3.getAdvertisementOption().getAdPackage())) {
            this.a(n2, string, messageV3);
        }
        this.c.notify(n2, notification);
    }

    private String h(MessageV3 messageV3) {
        if (messageV3 == null || messageV3.getAdvertisementOption() == null || TextUtils.isEmpty((CharSequence)messageV3.getAdvertisementOption().getAdPackage())) {
            return null;
        }
        String string = messageV3.getUploadDataPackageName();
        String string2 = messageV3.getAdvertisementOption().getAdPackage();
        DebugLogger.e("AbstractPushNotification", "again show old ad and replace package, uploadDataPackageName:" + string + ", adPackageName:" + string2);
        com.meizu.cloud.pushsdk.handler.a.a.a a2 = com.meizu.cloud.pushsdk.b.a(this.a).b();
        if (a2 != null) {
            a2.a();
        }
        messageV3.setUploadDataPackageName(string2);
        return string;
    }

    private void a(int n2, String string, MessageV3 messageV3) {
        if (messageV3 == null || messageV3.getAdvertisementOption() == null || TextUtils.isEmpty((CharSequence)messageV3.getAdvertisementOption().getAdPackage())) {
            return;
        }
        DebugLogger.e("AbstractPushNotification", "save ad and recovery package, uploadDataPackageName:" + string);
        com.meizu.cloud.pushsdk.handler.a.a.a a2 = com.meizu.cloud.pushsdk.b.a(this.a).b();
        if (a2 != null) {
            int n3 = messageV3.getAdvertisementOption().getPriorityValidTime();
            a2.a(messageV3);
            Notification notification = this.a(messageV3, this.c(messageV3), this.e(messageV3), this.f(messageV3));
            a2.a(n2, notification, n3);
        }
        messageV3.setUploadDataPackageName(string);
    }

    @SuppressLint(value={"NewApi"})
    private void b(Notification notification, MessageV3 messageV3) {
        com.meizu.cloud.pushsdk.notification.c.b.a(notification, true);
        com.meizu.cloud.pushsdk.notification.c.b.a(notification, this.g(messageV3));
        notification.extras.putString("android.originalPackageName", messageV3.getUploadDataPackageName());
        notification.extras.putString("android.flymeNotificationSetting", this.a(messageV3));
        notification.extras.putString("notification_extra_task_id", messageV3.getTaskId());
        notification.extras.putString("notification_extra_seq_id", messageV3.getSeqId());
        notification.extras.putString("notification_extra_device_id", messageV3.getDeviceId());
        notification.extras.putString("notification_extra_push_timestamp", messageV3.getPushTimestamp());
        if (!TextUtils.isEmpty((CharSequence)this.b.getAppLabel())) {
            DebugLogger.e("AbstractPushNotification", "set app label " + this.b.getAppLabel());
            notification.extras.putString("android.substName", this.b.getAppLabel());
        } else {
            String string = this.b(this.a, messageV3.getUploadDataPackageName());
            DebugLogger.e("AbstractPushNotification", "current package " + messageV3.getUploadDataPackageName() + " label is " + string);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                notification.extras.putString("android.substName", string);
            }
        }
    }

    private void d(Notification.Builder builder, MessageV3 messageV3) {
        int n2;
        String string;
        String string2;
        int n3;
        if (!MinSdkChecker.isSupportNotificationChannel()) {
            return;
        }
        AdvanceSetting advanceSetting = messageV3.getAdvanceSetting();
        AdvanceSettingEx advanceSettingEx = messageV3.getAdvanceSettingEx();
        int n4 = n3 = advanceSettingEx != null ? advanceSettingEx.getPriorityDisplay() : 0;
        if (Build.VERSION.SDK_INT >= 29 && advanceSetting.isHeadUpNotification() && advanceSettingEx.getPriorityDisplay() < 1) {
            n3 = 1;
        }
        switch (n3) {
            case -2: {
                string2 = "mz_push_notification_channel_min";
                string = "MEIZUPUSHMIN";
                n2 = 1;
                break;
            }
            case -1: {
                string2 = "mz_push_notification_channel_low";
                string = "MEIZUPUSHLOW";
                n2 = 2;
                break;
            }
            case 1: {
                string2 = "mz_push_notification_channel_high";
                string = "MEIZUPUSHHIGH";
                n2 = 4;
                break;
            }
            case 2: {
                string2 = "mz_push_notification_channel_max";
                string = "MEIZUPUSHMAX";
                n2 = 5;
                break;
            }
            default: {
                string2 = "mz_push_notification_channel";
                string = "MEIZUPUSH";
                n2 = 3;
            }
        }
        Uri uri = null;
        if (advanceSettingEx.getSoundTitle() != null) {
            uri = com.meizu.cloud.pushsdk.notification.c.b.b(this.a, advanceSettingEx.getSoundTitle());
        }
        if (!advanceSetting.getNotifyType().isSound() && advanceSettingEx.getSoundTitle() == null) {
            string2 = string2 + "_mute";
            string = string + "_MUTE";
        } else if (uri != null) {
            string2 = string2 + "_" + advanceSettingEx.getSoundTitle().toLowerCase();
            string = string + "_" + advanceSettingEx.getSoundTitle().toUpperCase();
        }
        DebugLogger.e("AbstractPushNotification", "notification channel builder, channelId: " + string2 + ", channelName: " + string + ", importance:" + n2 + ", sound: " + uri);
        NotificationChannel notificationChannel = new NotificationChannel(string2, (CharSequence)string, n2);
        notificationChannel.enableLights(true);
        notificationChannel.setLightColor(-16711936);
        notificationChannel.setShowBadge(true);
        notificationChannel.enableVibration(true);
        if (!advanceSetting.getNotifyType().isSound() && advanceSettingEx.getSoundTitle() == null) {
            notificationChannel.setSound(null, Notification.AUDIO_ATTRIBUTES_DEFAULT);
        } else if (uri != null) {
            notificationChannel.setSound(uri, Notification.AUDIO_ATTRIBUTES_DEFAULT);
        }
        this.c.createNotificationChannel(notificationChannel);
        builder.setChannelId(string2);
    }
}

