/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.umcrash.custom_exception;

import android.text.TextUtils;
import android.util.Log;
import com.uc.crashsdk.export.CrashApi;
import com.uc.crashsdk.export.CustomLogInfo;
import com.umeng.crash.UCrash;
import com.umeng.innner.umcrash.UMCrashThreadPoolExecutorFactory;
import com.umeng.umcrash.UMCrashUtils;
import com.umeng.umcrash.custom_exception.UMCustomLogInfoBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class UAPMCustomException {
    private static final String TAG = "UAPMCustomException";

    public static void generateCustomLog(final boolean enableUMUserLog, final boolean enableUCUserLog, final boolean isUploadNowUserCrash, final String e, final String type, final String errorMsg, final boolean withLogcat, final boolean allThreadsDump) {
        if (!enableUMUserLog && !enableUCUserLog) {
            Log.e((String)TAG, (String)"generate user is closed .");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)e) || TextUtils.isEmpty((CharSequence)type)) {
            Log.e((String)TAG, (String)"generate custom log failed ! e is null or type is empty .");
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    HashMap<String, String> kvInfoMap = new HashMap<String, String>(20);
                    kvInfoMap.put("k_ct", "exception");
                    kvInfoMap.put("k_ac", type);
                    StringBuffer sb = new StringBuffer();
                    for (Map.Entry entry : kvInfoMap.entrySet()) {
                        sb.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("\n");
                    }
                    String excepMsg = errorMsg == null ? "" : errorMsg;
                    String stack = "Exception message:" + excepMsg + "\n" + "Back traces starts." + "\n" + e + "\n" + "Back traces ends.";
                    if (!TextUtils.isEmpty((CharSequence)stack)) {
                        sb.append(stack).append("\n");
                    }
                    if (allThreadsDump) {
                        Map<String, String> map = UMCrashUtils.getAllThreadTraces();
                        sb.append("--- --- --- --- --- --- --- --- --- --- --- --- --- --- --- ---").append("\n").append("AllThreadsTraces: \n");
                        for (Map.Entry<String, String> entry : map.entrySet()) {
                            sb.append(entry.getKey()).append("\n").append(entry.getValue()).append("\n");
                        }
                    }
                    if (enableUMUserLog) {
                        UCrash.generateCustomLog((String)sb.toString(), (boolean)withLogcat);
                    } else if (enableUCUserLog) {
                        CustomLogInfo info = new CustomLogInfo(null, "exception");
                        ArrayList<String> mCallbacks = new ArrayList<String>();
                        mCallbacks.add("um_umid");
                        mCallbacks.add("um_infos:");
                        mCallbacks.add("um_user_string");
                        mCallbacks.add("um_user_str_custom_log:");
                        info.mCallbacks = mCallbacks;
                        Log.i((String)UAPMCustomException.TAG, (String)("upload is " + isUploadNowUserCrash));
                        info.mUploadNow = isUploadNowUserCrash;
                        info.mAddLogcat = withLogcat;
                        info.mData = sb;
                        CrashApi mCrashApi = CrashApi.getInstance();
                        if (mCrashApi == null) {
                            Log.e((String)UAPMCustomException.TAG, (String)"CrashApi is null, not init .");
                        } else {
                            mCrashApi.generateCustomLog(info);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        UMCrashThreadPoolExecutorFactory.execute(runnable);
    }

    public static void generateCustomLog(final boolean enableUMUserLog, final boolean enableUCUserLog, final boolean isUploadNowUserCrash, final Throwable e, final String type, final String errorMsg, final boolean withLogcat, final boolean allThreadsDump) {
        if (!enableUMUserLog && !enableUCUserLog) {
            Log.e((String)TAG, (String)"generate user is closed .");
            return;
        }
        if (e == null || TextUtils.isEmpty((CharSequence)type)) {
            Log.e((String)TAG, (String)"generate custom log failed ! e is null or type is empty .");
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    CustomLogInfo customLogInfo = null;
                    UMCustomLogInfoBuilder builder = new UMCustomLogInfoBuilder(type).stack(e, errorMsg).addLogCat(withLogcat);
                    if (allThreadsDump) {
                        StringBuilder threadTracesBuilder = new StringBuilder("AllThreadsTraces: \n");
                        Map<String, String> map = UMCrashUtils.getAllThreadTraces();
                        for (Map.Entry<String, String> entry : map.entrySet()) {
                            threadTracesBuilder.append(entry.getKey()).append("\n").append(entry.getValue()).append("\n");
                        }
                        customLogInfo = builder.addSection(threadTracesBuilder.toString()).build();
                    } else {
                        customLogInfo = builder.build();
                    }
                    if (enableUMUserLog) {
                        UCrash.generateCustomLog((String)customLogInfo.mData.toString(), (boolean)withLogcat);
                    } else if (enableUCUserLog) {
                        ArrayList<String> mCallbacks = new ArrayList<String>();
                        mCallbacks.add("um_umid");
                        mCallbacks.add("um_infos:");
                        mCallbacks.add("um_user_string");
                        mCallbacks.add("um_user_str_custom_log:");
                        customLogInfo.mCallbacks = mCallbacks;
                        Log.i((String)UAPMCustomException.TAG, (String)("upload is " + isUploadNowUserCrash));
                        customLogInfo.mUploadNow = isUploadNowUserCrash;
                        CrashApi mCrashApi = CrashApi.getInstance();
                        if (mCrashApi == null) {
                            Log.e((String)UAPMCustomException.TAG, (String)"CrashApi is null, not init .");
                        } else {
                            mCrashApi.generateCustomLog(customLogInfo);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        UMCrashThreadPoolExecutorFactory.execute(runnable);
    }
}

