/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.memleaksdk.monitor;

import android.os.Build;
import com.efs.sdk.memleaksdk.monitor.UMonitorReporter;
import com.efs.sdk.memleaksdk.monitor.internal.ai;
import java.util.Locale;

public class UMonitorConfigJava {
    private int analysisMaxTimesPerVersion;
    private int analysisPeriodPerVersion;
    private float heapThreshold;
    private int fdThreshold;
    private int threadThreshold;
    private float deviceMemoryThreshold;
    private int maxOverThresholdCount;
    private float forceDumpJavaHeapMaxThreshold;
    private int forceDumpJavaHeapDeltaThreshold;
    private long loopInterval;
    private boolean enableHprofDumpAnalysis;
    private boolean debugMode;
    private UMonitorReporter reporter;

    public int getAnalysisMaxTimesPerVersion() {
        return this.analysisMaxTimesPerVersion;
    }

    public int getAnalysisPeriodPerVersion() {
        return this.analysisPeriodPerVersion;
    }

    public float getHeapThreshold() {
        return this.heapThreshold;
    }

    public int getFdThreshold() {
        return this.fdThreshold;
    }

    public int getThreadThreshold() {
        return this.threadThreshold;
    }

    public float getDeviceMemoryThreshold() {
        return this.deviceMemoryThreshold;
    }

    public int getMaxOverThresholdCount() {
        return this.maxOverThresholdCount;
    }

    public float getForceDumpJavaHeapMaxThreshold() {
        return this.forceDumpJavaHeapMaxThreshold;
    }

    public int getForceDumpJavaHeapDeltaThreshold() {
        return this.forceDumpJavaHeapDeltaThreshold;
    }

    public long getLoopInterval() {
        return this.loopInterval;
    }

    public boolean getEnableHprofDumpAnalysis() {
        return this.enableHprofDumpAnalysis;
    }

    public UMonitorReporter getReporter() {
        return this.reporter;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    private UMonitorConfigJava() {
    }

    public static class Builder {
        private int analysisMaxTimesPerVersion = 5;
        private int analysisPeriodPerVersion = 1296000000;
        private int maxOverThresholdCount = 3;
        private Float heapThreshold = null;
        private int fdThreshold = 1000;
        private Integer threadThreshold = null;
        private float deviceMemoryThreshold = 0.05f;
        private float forceDumpJavaHeapMaxThreshold = 0.9f;
        private int forceDumpJavaHeapDeltaThreshold = 358400;
        private long loopInterval = 15000L;
        private boolean enableHprofDumpAnalysis = true;
        private boolean debugMode = true;
        private UMonitorReporter reporter;

        public Builder setDebugMode(boolean bl2) {
            this.debugMode = bl2;
            return this;
        }

        public Builder setAnalysisMaxTimesPerVersion(int n2) {
            this.analysisMaxTimesPerVersion = n2;
            return this;
        }

        public Builder setAnalysisPeriodPerVersion(int n2) {
            this.analysisPeriodPerVersion = n2;
            return this;
        }

        public Builder setHeapThreshold(float f2) {
            this.heapThreshold = Float.valueOf(f2);
            return this;
        }

        public Builder setFdThreshold(int n2) {
            this.fdThreshold = n2;
            return this;
        }

        public Builder setThreadThreshold(int n2) {
            this.threadThreshold = n2;
            return this;
        }

        public Builder setMaxOverThresholdCount(int n2) {
            this.maxOverThresholdCount = n2;
            return this;
        }

        public Builder setLoopInterval(long l2) {
            this.loopInterval = l2;
            return this;
        }

        public Builder setEnableHprofDumpAnalysis(boolean bl2) {
            this.enableHprofDumpAnalysis = bl2;
            return this;
        }

        public Builder setDeviceMemoryThreshold(float f2) {
            this.deviceMemoryThreshold = f2;
            return this;
        }

        public Builder setForceDumpJavaHeapDeltaThreshold(int n2) {
            this.forceDumpJavaHeapDeltaThreshold = n2;
            return this;
        }

        public Builder setForceDumpJavaHeapMaxThreshold(float f2) {
            this.forceDumpJavaHeapMaxThreshold = f2;
            return this;
        }

        public Builder setReporter(UMonitorReporter uMonitorReporter) {
            this.reporter = uMonitorReporter;
            return this;
        }

        public UMonitorConfigJava build() {
            if (this.heapThreshold == null) {
                float f2 = ai.a.b(Runtime.getRuntime().maxMemory());
                this.heapThreshold = f2 >= 502.0f ? Float.valueOf(0.8f) : (f2 >= 246.0f ? Float.valueOf(0.85f) : Float.valueOf(0.9f));
            }
            if (this.threadThreshold == null) {
                String string = Build.MANUFACTURER.toUpperCase(Locale.US);
                this.threadThreshold = ("HUAWEI".equals(string) || "EMUI".equals(string)) && Build.VERSION.SDK_INT <= 26 ? Integer.valueOf(450) : Integer.valueOf(750);
            }
            UMonitorConfigJava uMonitorConfigJava = new UMonitorConfigJava();
            uMonitorConfigJava.analysisMaxTimesPerVersion = this.analysisMaxTimesPerVersion;
            uMonitorConfigJava.analysisPeriodPerVersion = this.analysisPeriodPerVersion;
            uMonitorConfigJava.heapThreshold = this.heapThreshold.floatValue();
            uMonitorConfigJava.fdThreshold = this.fdThreshold;
            uMonitorConfigJava.threadThreshold = this.threadThreshold;
            uMonitorConfigJava.deviceMemoryThreshold = this.deviceMemoryThreshold;
            uMonitorConfigJava.maxOverThresholdCount = this.maxOverThresholdCount;
            uMonitorConfigJava.forceDumpJavaHeapMaxThreshold = this.forceDumpJavaHeapMaxThreshold;
            uMonitorConfigJava.forceDumpJavaHeapDeltaThreshold = this.forceDumpJavaHeapDeltaThreshold;
            uMonitorConfigJava.loopInterval = this.loopInterval;
            uMonitorConfigJava.enableHprofDumpAnalysis = this.enableHprofDumpAnalysis;
            uMonitorConfigJava.reporter = this.reporter;
            uMonitorConfigJava.debugMode = this.debugMode;
            return uMonitorConfigJava;
        }
    }
}

