/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.crash;

import com.umeng.crash.UCrashCallback;

public class UCrashConfig {
    boolean logEnable;
    boolean nativeCrashEnable;
    boolean nativeCrashRethrow;
    boolean nativeDumpAllThreads;
    boolean anrEnable;
    boolean anrTraceHkEnable;
    boolean javaCrashEnable;
    boolean javaCrashRethrow;
    boolean javaDumpAllThreads;
    boolean customEnable;
    boolean customUploadImmediately;
    int customFileSaveLimit;
    int customFileUploadLimit;
    String url;
    UCrashCallback callback;
    boolean backupEnable;
    String backupDir;

    public static class Builder {
        private boolean logEnable;
        private boolean nativeCrashEnable;
        private boolean nativeCrashRethrow = true;
        private boolean nativeDumpAllThreads;
        private boolean anrEnable;
        private boolean anrTraceHkEnable;
        private boolean javaCrashEnable;
        private boolean javaCrashRethrow = true;
        private boolean javaDumpAllThreads;
        private boolean customEnable;
        private boolean customUploadImmediately;
        private int customFileSaveLimit = 20;
        private int customFileUploadLimit = 20;
        private String url;
        private UCrashCallback callback;
        private boolean backupEnable;
        private String backupDir;

        public Builder setUrl(String string) {
            this.url = string;
            return this;
        }

        public Builder setLogEnable(boolean bl) {
            this.logEnable = bl;
            return this;
        }

        public Builder setCallback(UCrashCallback uCrashCallback) {
            this.callback = uCrashCallback;
            return this;
        }

        public Builder setAnrEnable(boolean bl) {
            this.anrEnable = bl;
            return this;
        }

        public Builder setAnrTraceHkEnable(boolean bl) {
            this.anrTraceHkEnable = this.anrEnable;
            return this;
        }

        public Builder setNativeCrashEnable(boolean bl) {
            this.nativeCrashEnable = bl;
            return this;
        }

        public Builder setNativeCrashRethrow(boolean bl) {
            this.nativeCrashRethrow = bl;
            return this;
        }

        public Builder setJavaCrashEnable(boolean bl) {
            this.javaCrashEnable = bl;
            return this;
        }

        public Builder setJavaCrashRethrow(boolean bl) {
            this.javaCrashRethrow = bl;
            return this;
        }

        public Builder setJavaDumpAllThreads(boolean bl) {
            this.javaDumpAllThreads = bl;
            return this;
        }

        public Builder setNativeDumpAllThreads(boolean bl) {
            this.nativeDumpAllThreads = bl;
            return this;
        }

        public Builder setCustomEnable(boolean bl) {
            this.customEnable = bl;
            return this;
        }

        public Builder setCustomUploadImmediately(boolean bl) {
            this.customUploadImmediately = bl;
            return this;
        }

        public Builder setCustomFileSaveLimit(int n) {
            this.customFileSaveLimit = n;
            return this;
        }

        public Builder setCustomFileUploadLimit(int n) {
            this.customFileUploadLimit = n;
            return this;
        }

        public Builder setBackupDir(String string) {
            this.backupDir = string;
            return this;
        }

        public Builder setBackupEnable(boolean bl) {
            this.backupEnable = bl;
            return this;
        }

        public UCrashConfig build() {
            UCrashConfig uCrashConfig = new UCrashConfig();
            new UCrashConfig().logEnable = this.logEnable;
            uCrashConfig.nativeCrashEnable = this.nativeCrashEnable;
            uCrashConfig.nativeCrashRethrow = this.nativeCrashRethrow;
            uCrashConfig.nativeDumpAllThreads = this.nativeDumpAllThreads;
            uCrashConfig.anrEnable = this.anrEnable;
            uCrashConfig.anrTraceHkEnable = this.anrTraceHkEnable;
            uCrashConfig.url = this.url;
            uCrashConfig.callback = this.callback;
            uCrashConfig.javaCrashEnable = this.javaCrashEnable;
            uCrashConfig.javaCrashRethrow = this.javaCrashRethrow;
            uCrashConfig.javaDumpAllThreads = this.javaDumpAllThreads;
            uCrashConfig.customEnable = this.customEnable;
            uCrashConfig.customUploadImmediately = this.customUploadImmediately;
            uCrashConfig.customFileSaveLimit = this.customFileSaveLimit;
            uCrashConfig.customFileUploadLimit = this.customFileUploadLimit;
            uCrashConfig.backupDir = this.backupDir;
            uCrashConfig.backupEnable = this.backupEnable;
            return uCrashConfig;
        }
    }
}

