/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.pa;

import android.content.Context;
import android.util.Log;
import com.efs.sdk.base.EfsReporter;
import com.efs.sdk.pa.IPaClient;
import com.efs.sdk.pa.PA;
import com.efs.sdk.pa.PATraceListener;
import com.efs.sdk.pa.a;
import com.efs.sdk.pa.a.c;
import com.efs.sdk.pa.config.ConfigManager;
import com.efs.sdk.pa.config.IEfsReporter;
import com.efs.sdk.pa.config.PackageLevel;
import java.util.HashMap;

public class PAFactory {
    static final ThreadLocal<PA> sThreadLocal = new ThreadLocal();
    private static final long DEFAULT_TIME_OUT_TIME = 2000L;
    private static final long MAX_TIME_OUT_TIME = 4000L;
    private static final long INVALID_TIME_OUT_TIME = 0L;
    private static final String TAG = "pafactory";
    private IEfsReporter mReporterFactory;
    private EfsReporter mReporter;
    private ConfigManager mConfigManager;
    private String mSerial;
    private String mSver;
    private HashMap<String, String> mExtend;
    private Context mContext;
    private PATraceListener mTraceListener;
    private IPaClient mPaClient;
    private long mTimeOutTime;

    public synchronized PA getPaInstance() {
        PA pA = sThreadLocal.get();
        if (pA == null) {
            pA = new c(this.mConfigManager.enableTracer());
            pA.registerPAANRListener(this.mContext, new a(this), this.mTimeOutTime);
            sThreadLocal.set(pA);
        }
        return pA;
    }

    private PAFactory(Context context, PackageLevel packageLevel, IEfsReporter iEfsReporter, boolean bl, String string, HashMap<String, String> hashMap, String string2, long l, PATraceListener pATraceListener, IPaClient iPaClient) {
        this.mReporterFactory = iEfsReporter;
        this.mSerial = string;
        this.mExtend = hashMap;
        this.mSver = string2;
        this.mContext = context;
        this.mTraceListener = pATraceListener;
        this.mPaClient = iPaClient;
        this.mTimeOutTime = l;
        this.mConfigManager = new ConfigManager(context, packageLevel, iEfsReporter, bl);
    }

    public IPaClient getPaClient() {
        return this.mPaClient;
    }

    public PATraceListener getTraceListener() {
        return this.mTraceListener;
    }

    public ConfigManager getConfigManager() {
        return this.mConfigManager;
    }

    public String getSerial() {
        return this.mSerial;
    }

    public String getSver() {
        return this.mSver;
    }

    public HashMap<String, String> getExtend() {
        return this.mExtend;
    }

    public EfsReporter getReporter() {
        if (this.mReporter == null) {
            this.mReporter = this.mReporterFactory != null ? this.mReporterFactory.getReporter() : null;
        }
        return this.mReporter;
    }

    public Context getContext() {
        return this.mContext;
    }

    public static class Builder {
        private PackageLevel a;
        private IEfsReporter b;
        private boolean c;
        private Context d;
        private String e;
        private HashMap<String, String> f;
        private String g;
        private long h = 2000L;
        private PATraceListener i;
        private IPaClient j;

        public Builder(Context context, IEfsReporter iEfsReporter) {
            if (context == null) {
                throw new RuntimeException("context Should Not null");
            }
            if (iEfsReporter == null) {
                throw new RuntimeException("reporter Should Not Empty");
            }
            this.b = iEfsReporter;
            this.d = context;
        }

        public Builder packageLevel(PackageLevel packageLevel) {
            this.a = packageLevel;
            return this;
        }

        public Builder isNewInstall(boolean bl) {
            this.c = bl;
            return this;
        }

        public Builder serial(String string) {
            this.e = string;
            return this;
        }

        public Builder extendLogInfo(HashMap<String, String> hashMap) {
            this.f = hashMap;
            return this;
        }

        public Builder sver(String string) {
            this.g = string;
            return this;
        }

        public Builder traceListener(PATraceListener pATraceListener) {
            this.i = pATraceListener;
            return this;
        }

        public Builder setPaClient(IPaClient iPaClient) {
            this.j = iPaClient;
            return this;
        }

        public Builder timeoutTime(long l) {
            if (l <= 0L) {
                Log.w((String)PAFactory.TAG, (String)"Timeout time is invalid, and the default value 2s will be used");
                this.h = 2000L;
            } else {
                if (l > 4000L) {
                    Log.w((String)PAFactory.TAG, (String)"Timeout time over 4s is not recommended, and the default value 2s will be used");
                    this.h = 2000L;
                    return this;
                }
                this.h = l;
            }
            return this;
        }

        public PAFactory build() {
            String string = "";
            if (this.a == null) {
                throw new RuntimeException(String.format("%s Should Not Null", string));
            }
            return new PAFactory(this.d, this.a, this.b, this.c, this.e, this.f, this.g, this.h, this.i, this.j);
        }
    }
}

