/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.Contract;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Contract
public class SlackRateLimitRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private static final int SC_TOO_MANY_REQUESTS = 429;
    private static final long DEFAULT_RETRY_INTERVAL = 3000L;
    private static final int DEFAULT_MAX_RETRIES = 3;
    private final int maxRetries;
    private long retryInterval;

    public SlackRateLimitRetryStrategy() {
        this(3, 3000L);
    }

    public SlackRateLimitRetryStrategy(int maxRetries, long retryInterval) {
        this.maxRetries = Args.positive((int)maxRetries, (String)"Max retries");
        this.retryInterval = Args.positive((long)retryInterval, (String)"Retry interval");
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        if (executionCount > this.maxRetries || response.getStatusLine().getStatusCode() != 429) {
            return false;
        }
        this.retryInterval = 3000L;
        try {
            Header header = response.getFirstHeader("Retry-After");
            if (header != null) {
                this.retryInterval = (long)Integer.parseInt(header.getValue()) * 1000L;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return true;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }
}

