/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.blocks.compositions;

import com.ullink.slack.simpleslackapi.blocks.compositions.Option;
import com.ullink.slack.simpleslackapi.blocks.compositions.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class OptionGroup {
    @NonNull
    private Text label;
    private List<Option> options;

    protected OptionGroup(OptionGroupBuilder<?, ?> b) {
        List<Object> options;
        this.label = ((OptionGroupBuilder)b).label;
        if (this.label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        switch (((OptionGroupBuilder)b).options == null ? 0 : ((OptionGroupBuilder)b).options.size()) {
            case 0: {
                options = Collections.emptyList();
                break;
            }
            case 1: {
                options = Collections.singletonList(((OptionGroupBuilder)b).options.get(0));
                break;
            }
            default: {
                options = Collections.unmodifiableList(new ArrayList(((OptionGroupBuilder)b).options));
            }
        }
        this.options = options;
    }

    public static OptionGroupBuilder<?, ?> builder() {
        return new OptionGroupBuilderImpl();
    }

    public OptionGroup() {
    }

    private OptionGroup(@NonNull Text label, List<Option> options) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        this.options = options;
    }

    @NonNull
    public Text getLabel() {
        return this.label;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    private static final class OptionGroupBuilderImpl
    extends OptionGroupBuilder<OptionGroup, OptionGroupBuilderImpl> {
        private OptionGroupBuilderImpl() {
        }

        @Override
        protected OptionGroupBuilderImpl self() {
            return this;
        }

        @Override
        public OptionGroup build() {
            return new OptionGroup(this);
        }
    }

    public static abstract class OptionGroupBuilder<C extends OptionGroup, B extends OptionGroupBuilder<C, B>> {
        private Text label;
        private ArrayList<Option> options;

        protected abstract B self();

        public abstract C build();

        public B label(@NonNull Text label) {
            if (label == null) {
                throw new NullPointerException("label is marked non-null but is null");
            }
            this.label = label;
            return this.self();
        }

        public B option(Option option) {
            if (this.options == null) {
                this.options = new ArrayList();
            }
            this.options.add(option);
            return this.self();
        }

        public B options(Collection<? extends Option> options) {
            if (this.options == null) {
                this.options = new ArrayList();
            }
            this.options.addAll(options);
            return this.self();
        }

        public B clearOptions() {
            if (this.options != null) {
                this.options.clear();
            }
            return this.self();
        }

        public String toString() {
            return "OptionGroup.OptionGroupBuilder(label=" + this.label + ", options=" + this.options + ")";
        }
    }
}

