/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.blocks.compositions;

import com.ullink.slack.simpleslackapi.blocks.compositions.Text;

public class Option {
    private Text text;
    private String value;
    private String url;

    protected Option(OptionBuilder<?, ?> b) {
        this.text = ((OptionBuilder)b).text;
        this.value = ((OptionBuilder)b).value;
        this.url = ((OptionBuilder)b).url;
    }

    public static OptionBuilder<?, ?> builder() {
        return new OptionBuilderImpl();
    }

    public Option() {
    }

    private Option(Text text, String value, String url) {
        this.text = text;
        this.value = value;
        this.url = url;
    }

    public Text getText() {
        return this.text;
    }

    public String getValue() {
        return this.value;
    }

    public String getUrl() {
        return this.url;
    }

    private static final class OptionBuilderImpl
    extends OptionBuilder<Option, OptionBuilderImpl> {
        private OptionBuilderImpl() {
        }

        @Override
        protected OptionBuilderImpl self() {
            return this;
        }

        @Override
        public Option build() {
            return new Option(this);
        }
    }

    public static abstract class OptionBuilder<C extends Option, B extends OptionBuilder<C, B>> {
        private Text text;
        private String value;
        private String url;

        protected abstract B self();

        public abstract C build();

        public B text(Text text) {
            this.text = text;
            return this.self();
        }

        public B value(String value) {
            this.value = value;
            return this.self();
        }

        public B url(String url) {
            this.url = url;
            return this.self();
        }

        public String toString() {
            return "Option.OptionBuilder(text=" + this.text + ", value=" + this.value + ", url=" + this.url + ")";
        }
    }
}

