/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi;

import com.google.gson.annotations.SerializedName;
import com.ullink.slack.simpleslackapi.SlackAttachment;
import com.ullink.slack.simpleslackapi.blocks.Block;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SlackPreparedMessage {
    @SerializedName(value="text")
    private String message;
    private boolean unfurl;
    private boolean linkNames;
    private List<SlackAttachment> attachments;
    private List<Block> blocks;
    private String threadTimestamp;
    private boolean replyBroadcast;

    public String toString() {
        return "SlackPreparedMessage{message='" + this.message + '\'' + ", unfurl=" + this.unfurl + ", attachments=" + this.attachments + ", blocks=" + this.blocks + '}';
    }

    public static SlackPreparedMessageBuilder builder() {
        return new SlackPreparedMessageBuilder();
    }

    public SlackPreparedMessage(String message, boolean unfurl, boolean linkNames, List<SlackAttachment> attachments, List<Block> blocks, String threadTimestamp, boolean replyBroadcast) {
        this.message = message;
        this.unfurl = unfurl;
        this.linkNames = linkNames;
        this.attachments = attachments;
        this.blocks = blocks;
        this.threadTimestamp = threadTimestamp;
        this.replyBroadcast = replyBroadcast;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isUnfurl() {
        return this.unfurl;
    }

    public boolean isLinkNames() {
        return this.linkNames;
    }

    public List<SlackAttachment> getAttachments() {
        return this.attachments;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public String getThreadTimestamp() {
        return this.threadTimestamp;
    }

    public boolean isReplyBroadcast() {
        return this.replyBroadcast;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlackPreparedMessage)) {
            return false;
        }
        SlackPreparedMessage other = (SlackPreparedMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        if (this.isUnfurl() != other.isUnfurl()) {
            return false;
        }
        if (this.isLinkNames() != other.isLinkNames()) {
            return false;
        }
        List<SlackAttachment> this$attachments = this.getAttachments();
        List<SlackAttachment> other$attachments = other.getAttachments();
        if (this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments)) {
            return false;
        }
        List<Block> this$blocks = this.getBlocks();
        List<Block> other$blocks = other.getBlocks();
        if (this$blocks == null ? other$blocks != null : !((Object)this$blocks).equals(other$blocks)) {
            return false;
        }
        String this$threadTimestamp = this.getThreadTimestamp();
        String other$threadTimestamp = other.getThreadTimestamp();
        if (this$threadTimestamp == null ? other$threadTimestamp != null : !this$threadTimestamp.equals(other$threadTimestamp)) {
            return false;
        }
        return this.isReplyBroadcast() == other.isReplyBroadcast();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlackPreparedMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        result = result * 59 + (this.isUnfurl() ? 79 : 97);
        result = result * 59 + (this.isLinkNames() ? 79 : 97);
        List<SlackAttachment> $attachments = this.getAttachments();
        result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
        List<Block> $blocks = this.getBlocks();
        result = result * 59 + ($blocks == null ? 43 : ((Object)$blocks).hashCode());
        String $threadTimestamp = this.getThreadTimestamp();
        result = result * 59 + ($threadTimestamp == null ? 43 : $threadTimestamp.hashCode());
        result = result * 59 + (this.isReplyBroadcast() ? 79 : 97);
        return result;
    }

    public static class SlackPreparedMessageBuilder {
        private String message;
        private boolean unfurl;
        private boolean linkNames;
        private ArrayList<SlackAttachment> attachments;
        private ArrayList<Block> blocks;
        private String threadTimestamp;
        private boolean replyBroadcast;

        SlackPreparedMessageBuilder() {
        }

        public SlackPreparedMessageBuilder message(String message) {
            this.message = message;
            return this;
        }

        public SlackPreparedMessageBuilder unfurl(boolean unfurl) {
            this.unfurl = unfurl;
            return this;
        }

        public SlackPreparedMessageBuilder linkNames(boolean linkNames) {
            this.linkNames = linkNames;
            return this;
        }

        public SlackPreparedMessageBuilder attachment(SlackAttachment attachment) {
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.add(attachment);
            return this;
        }

        public SlackPreparedMessageBuilder attachments(Collection<? extends SlackAttachment> attachments) {
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.addAll(attachments);
            return this;
        }

        public SlackPreparedMessageBuilder clearAttachments() {
            if (this.attachments != null) {
                this.attachments.clear();
            }
            return this;
        }

        public SlackPreparedMessageBuilder block(Block block) {
            if (this.blocks == null) {
                this.blocks = new ArrayList();
            }
            this.blocks.add(block);
            return this;
        }

        public SlackPreparedMessageBuilder blocks(Collection<? extends Block> blocks) {
            if (this.blocks == null) {
                this.blocks = new ArrayList();
            }
            this.blocks.addAll(blocks);
            return this;
        }

        public SlackPreparedMessageBuilder clearBlocks() {
            if (this.blocks != null) {
                this.blocks.clear();
            }
            return this;
        }

        public SlackPreparedMessageBuilder threadTimestamp(String threadTimestamp) {
            this.threadTimestamp = threadTimestamp;
            return this;
        }

        public SlackPreparedMessageBuilder replyBroadcast(boolean replyBroadcast) {
            this.replyBroadcast = replyBroadcast;
            return this;
        }

        public SlackPreparedMessage build() {
            List<Block> blocks;
            List<SlackAttachment> attachments;
            switch (this.attachments == null ? 0 : this.attachments.size()) {
                case 0: {
                    attachments = Collections.emptyList();
                    break;
                }
                case 1: {
                    attachments = Collections.singletonList(this.attachments.get(0));
                    break;
                }
                default: {
                    attachments = Collections.unmodifiableList(new ArrayList<SlackAttachment>(this.attachments));
                }
            }
            switch (this.blocks == null ? 0 : this.blocks.size()) {
                case 0: {
                    blocks = Collections.emptyList();
                    break;
                }
                case 1: {
                    blocks = Collections.singletonList(this.blocks.get(0));
                    break;
                }
                default: {
                    blocks = Collections.unmodifiableList(new ArrayList<Block>(this.blocks));
                }
            }
            return new SlackPreparedMessage(this.message, this.unfurl, this.linkNames, attachments, blocks, this.threadTimestamp, this.replyBroadcast);
        }

        public String toString() {
            return "SlackPreparedMessage.SlackPreparedMessageBuilder(message=" + this.message + ", unfurl=" + this.unfurl + ", linkNames=" + this.linkNames + ", attachments=" + this.attachments + ", blocks=" + this.blocks + ", threadTimestamp=" + this.threadTimestamp + ", replyBroadcast=" + this.replyBroadcast + ")";
        }
    }
}

