/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi;

import com.google.gson.annotations.SerializedName;
import com.ullink.slack.simpleslackapi.SlackAction;
import com.ullink.slack.simpleslackapi.SlackField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlackAttachment {
    private String title;
    private String title_link;
    private String fallback;
    private String callback_id;
    private String text;
    private String pretext;
    private String thumb_url;
    private String author_name;
    private String author_link;
    private String author_icon;
    private String footer;
    private String footer_icon;
    private String image_url;
    private String color;
    @SerializedName(value="ts")
    private String timestamp;
    private transient Map<String, String> miscRootFields;
    private List<SlackField> fields;
    private List<SlackAction> actions;
    private List<String> markdown_in;

    public SlackAttachment() {
        this.actions = new ArrayList<SlackAction>();
        this.fields = new ArrayList<SlackField>();
    }

    @Deprecated
    public SlackAttachment(String title, String fallback, String text, String pretext) {
        this.title = title;
        this.fallback = fallback;
        this.text = text;
        this.pretext = pretext;
        this.actions = new ArrayList<SlackAction>();
        this.fields = new ArrayList<SlackField>();
    }

    public String toString() {
        return "SlackAttachment [title=" + this.title + ", fallback=" + this.fallback + ", text=" + this.text + ", pretext=" + this.pretext + ", fields=" + this.fields + "]";
    }

    public void addField(String title, String value, boolean isShort) {
        this.fields.add(new SlackField(title, value, isShort));
    }

    public void addAction(String name, String value, String text, String type) {
        this.actions.add(new SlackAction(name, text, type, value));
    }

    public void addAction(SlackAction action) {
        this.actions.add(action);
    }

    public void addMarkdownIn(String value) {
        if (this.markdown_in == null) {
            this.markdown_in = new ArrayList<String>();
        }
        this.markdown_in.add(value);
    }

    public void addMiscField(String key, String value) {
        if (this.miscRootFields == null) {
            this.miscRootFields = new HashMap<String, String>();
        }
        this.miscRootFields.put(key, value);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitleLink(String titleLink) {
        this.title_link = titleLink;
    }

    public void setFallback(String fallback) {
        this.fallback = fallback;
    }

    public void setCallbackId(String callback_id) {
        this.callback_id = callback_id;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setPretext(String pretext) {
        this.pretext = pretext;
    }

    public void setThumbUrl(String thumb_url) {
        this.thumb_url = thumb_url;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setImageUrl(String image_url) {
        this.image_url = image_url;
    }

    public void setAuthorName(String author_name) {
        this.author_name = author_name;
    }

    public void setAuthorLink(String author_link) {
        this.author_link = author_link;
    }

    public void setAuthorIcon(String author_icon) {
        this.author_icon = author_icon;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public void setFooterIcon(String footer_icon) {
        this.footer_icon = footer_icon;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleLink() {
        return this.title_link;
    }

    public String getFallback() {
        return this.fallback;
    }

    public String getCallbackId() {
        return this.callback_id;
    }

    public String getText() {
        return this.text;
    }

    public String getPretext() {
        return this.pretext;
    }

    public String getThumbUrl() {
        return this.thumb_url;
    }

    public String getColor() {
        return this.color;
    }

    public Map<String, String> getMiscRootFields() {
        return this.miscRootFields;
    }

    public List<SlackField> getFields() {
        return this.fields;
    }

    public List<SlackAction> getActions() {
        return this.actions;
    }

    public List<String> getMarkdown_in() {
        return this.markdown_in;
    }

    public String getImageUrl() {
        return this.image_url;
    }

    public String getAuthorName() {
        return this.author_name;
    }

    public String getAuthorLink() {
        return this.author_link;
    }

    public String getAuthorIcon() {
        return this.author_icon;
    }

    public String getFooter() {
        return this.footer;
    }

    public String getFooterIcon() {
        return this.footer_icon;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public static SlackAttachmentBuilder builder() {
        return new SlackAttachmentBuilder();
    }

    public SlackAttachment(String title, String title_link, String fallback, String callback_id, String text, String pretext, String thumb_url, String author_name, String author_link, String author_icon, String footer, String footer_icon, String image_url, String color, String timestamp, Map<String, String> miscRootFields, List<SlackField> fields, List<SlackAction> actions, List<String> markdown_in) {
        this.title = title;
        this.title_link = title_link;
        this.fallback = fallback;
        this.callback_id = callback_id;
        this.text = text;
        this.pretext = pretext;
        this.thumb_url = thumb_url;
        this.author_name = author_name;
        this.author_link = author_link;
        this.author_icon = author_icon;
        this.footer = footer;
        this.footer_icon = footer_icon;
        this.image_url = image_url;
        this.color = color;
        this.timestamp = timestamp;
        this.miscRootFields = miscRootFields;
        this.fields = fields;
        this.actions = actions;
        this.markdown_in = markdown_in;
    }

    public static class SlackAttachmentBuilder {
        private String title;
        private String title_link;
        private String fallback;
        private String callback_id;
        private String text;
        private String pretext;
        private String thumb_url;
        private String author_name;
        private String author_link;
        private String author_icon;
        private String footer;
        private String footer_icon;
        private String image_url;
        private String color;
        private String timestamp;
        private Map<String, String> miscRootFields;
        private ArrayList<SlackField> fields;
        private ArrayList<SlackAction> actions;
        private List<String> markdown_in;

        SlackAttachmentBuilder() {
        }

        public SlackAttachmentBuilder title(String title) {
            this.title = title;
            return this;
        }

        public SlackAttachmentBuilder title_link(String title_link) {
            this.title_link = title_link;
            return this;
        }

        public SlackAttachmentBuilder fallback(String fallback) {
            this.fallback = fallback;
            return this;
        }

        public SlackAttachmentBuilder callback_id(String callback_id) {
            this.callback_id = callback_id;
            return this;
        }

        public SlackAttachmentBuilder text(String text) {
            this.text = text;
            return this;
        }

        public SlackAttachmentBuilder pretext(String pretext) {
            this.pretext = pretext;
            return this;
        }

        public SlackAttachmentBuilder thumb_url(String thumb_url) {
            this.thumb_url = thumb_url;
            return this;
        }

        public SlackAttachmentBuilder author_name(String author_name) {
            this.author_name = author_name;
            return this;
        }

        public SlackAttachmentBuilder author_link(String author_link) {
            this.author_link = author_link;
            return this;
        }

        public SlackAttachmentBuilder author_icon(String author_icon) {
            this.author_icon = author_icon;
            return this;
        }

        public SlackAttachmentBuilder footer(String footer) {
            this.footer = footer;
            return this;
        }

        public SlackAttachmentBuilder footer_icon(String footer_icon) {
            this.footer_icon = footer_icon;
            return this;
        }

        public SlackAttachmentBuilder image_url(String image_url) {
            this.image_url = image_url;
            return this;
        }

        public SlackAttachmentBuilder color(String color) {
            this.color = color;
            return this;
        }

        public SlackAttachmentBuilder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SlackAttachmentBuilder miscRootFields(Map<String, String> miscRootFields) {
            this.miscRootFields = miscRootFields;
            return this;
        }

        public SlackAttachmentBuilder field(SlackField field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return this;
        }

        public SlackAttachmentBuilder fields(Collection<? extends SlackField> fields) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return this;
        }

        public SlackAttachmentBuilder clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return this;
        }

        public SlackAttachmentBuilder action(SlackAction action) {
            if (this.actions == null) {
                this.actions = new ArrayList();
            }
            this.actions.add(action);
            return this;
        }

        public SlackAttachmentBuilder actions(Collection<? extends SlackAction> actions) {
            if (this.actions == null) {
                this.actions = new ArrayList();
            }
            this.actions.addAll(actions);
            return this;
        }

        public SlackAttachmentBuilder clearActions() {
            if (this.actions != null) {
                this.actions.clear();
            }
            return this;
        }

        public SlackAttachmentBuilder markdown_in(List<String> markdown_in) {
            this.markdown_in = markdown_in;
            return this;
        }

        public SlackAttachment build() {
            List<SlackAction> actions;
            List<SlackField> fields;
            switch (this.fields == null ? 0 : this.fields.size()) {
                case 0: {
                    fields = Collections.emptyList();
                    break;
                }
                case 1: {
                    fields = Collections.singletonList(this.fields.get(0));
                    break;
                }
                default: {
                    fields = Collections.unmodifiableList(new ArrayList<SlackField>(this.fields));
                }
            }
            switch (this.actions == null ? 0 : this.actions.size()) {
                case 0: {
                    actions = Collections.emptyList();
                    break;
                }
                case 1: {
                    actions = Collections.singletonList(this.actions.get(0));
                    break;
                }
                default: {
                    actions = Collections.unmodifiableList(new ArrayList<SlackAction>(this.actions));
                }
            }
            return new SlackAttachment(this.title, this.title_link, this.fallback, this.callback_id, this.text, this.pretext, this.thumb_url, this.author_name, this.author_link, this.author_icon, this.footer, this.footer_icon, this.image_url, this.color, this.timestamp, this.miscRootFields, fields, actions, this.markdown_in);
        }

        public String toString() {
            return "SlackAttachment.SlackAttachmentBuilder(title=" + this.title + ", title_link=" + this.title_link + ", fallback=" + this.fallback + ", callback_id=" + this.callback_id + ", text=" + this.text + ", pretext=" + this.pretext + ", thumb_url=" + this.thumb_url + ", author_name=" + this.author_name + ", author_link=" + this.author_link + ", author_icon=" + this.author_icon + ", footer=" + this.footer + ", footer_icon=" + this.footer_icon + ", image_url=" + this.image_url + ", color=" + this.color + ", timestamp=" + this.timestamp + ", miscRootFields=" + this.miscRootFields + ", fields=" + this.fields + ", actions=" + this.actions + ", markdown_in=" + this.markdown_in + ")";
        }
    }
}

