/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi;

import com.ullink.slack.simpleslackapi.events.SlackMessagePosted;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.threeten.bp.LocalDate;

public interface ChannelHistoryModule {
    public SlackMessagePosted fetchMessageFromChannel(String var1, String var2);

    public List<SlackMessagePosted> fetchHistoryOfChannel(String var1);

    public List<SlackMessagePosted> fetchHistoryOfChannel(String var1, LocalDate var2);

    public List<SlackMessagePosted> fetchHistoryOfChannel(String var1, int var2);

    public List<SlackMessagePosted> fetchHistoryOfChannel(String var1, LocalDate var2, int var3);

    public List<SlackMessagePosted> fetchHistoryOfChannel(String var1, LocalDate var2, int var3, MessageSubTypeFilter var4);

    public List<SlackMessagePosted> fetchHistoryOfChannel(String var1, LocalDate var2, int var3, Set<String> var4);

    public List<SlackMessagePosted> fetchUpdatingHistoryOfChannel(String var1);

    public List<SlackMessagePosted> fetchUpdatingHistoryOfChannel(String var1, LocalDate var2);

    public List<SlackMessagePosted> fetchUpdatingHistoryOfChannel(String var1, int var2);

    public List<SlackMessagePosted> fetchUpdatingHistoryOfChannel(String var1, LocalDate var2, int var3);

    public static enum MessageSubTypeFilter {
        USERS_AND_INTERNAL_MESSAGES{

            @Override
            public Set<String> getRetainedSubtypes() {
                return this.USERS_AND_INTERNAL_MESSAGES_CODE_SET;
            }
        }
        ,
        USERS_MESSAGES{

            @Override
            public Set<String> getRetainedSubtypes() {
                return this.USERS_MESSAGES_CODE_SET;
            }
        };

        Set<String> USERS_AND_INTERNAL_MESSAGES_CODE_SET = this.getUsersAndInternalMessagesSubTypesCode();
        Set<String> USERS_MESSAGES_CODE_SET = this.getUsersMessagesSubTypesCode();

        public abstract Set<String> getRetainedSubtypes();

        private Set<String> getUsersAndInternalMessagesSubTypesCode() {
            HashSet<String> toReturn = new HashSet<String>();
            for (SlackMessagePosted.MessageSubType subType : SlackMessagePosted.MessageSubType.values()) {
                toReturn.add(subType.getCode());
            }
            return toReturn;
        }

        private Set<String> getUsersMessagesSubTypesCode() {
            HashSet<String> toReturn = new HashSet<String>();
            toReturn.add(SlackMessagePosted.MessageSubType.BOT_MESSAGE.getCode());
            return toReturn;
        }
    }
}

