/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.watch;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.support.clock.SystemClock;
import org.elasticsearch.xpack.watcher.actions.Action;
import org.elasticsearch.xpack.watcher.actions.ActionStatus;
import org.elasticsearch.xpack.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.watcher.support.xcontent.WatcherXContentParser;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class WatchStatus
implements ToXContentObject,
Streamable {
    public static final String INCLUDE_VERSION_KEY = "include_version";
    private transient long version;
    private State state;
    @Nullable
    private DateTime lastChecked;
    @Nullable
    private DateTime lastMetCondition;
    private Map<String, ActionStatus> actions;
    private volatile boolean dirty = false;

    private WatchStatus() {
    }

    public WatchStatus(DateTime now, Map<String, ActionStatus> actions) {
        this(-1L, new State(true, now), null, null, actions);
    }

    public WatchStatus(WatchStatus other) {
        this(other.version, other.state, other.lastChecked, other.lastMetCondition, other.actions);
    }

    private WatchStatus(long version, State state, DateTime lastChecked, DateTime lastMetCondition, Map<String, ActionStatus> actions) {
        this.version = version;
        this.lastChecked = lastChecked;
        this.lastMetCondition = lastMetCondition;
        this.actions = actions;
        this.state = state;
    }

    public State state() {
        return this.state;
    }

    public long version() {
        return this.version;
    }

    public void version(long version) {
        this.version = version;
    }

    public boolean checked() {
        return this.lastChecked != null;
    }

    public DateTime lastChecked() {
        return this.lastChecked;
    }

    public ActionStatus actionStatus(String actionId) {
        return this.actions.get(actionId);
    }

    public void resetDirty() {
        this.dirty = false;
    }

    public boolean dirty() {
        return this.dirty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchStatus that = (WatchStatus)o;
        if (this.version != that.version) {
            return false;
        }
        if (this.lastChecked != null ? !this.lastChecked.equals(that.lastChecked) : that.lastChecked != null) {
            return false;
        }
        if (this.lastMetCondition != null ? !this.lastMetCondition.equals(that.lastMetCondition) : that.lastMetCondition != null) {
            return false;
        }
        return !(this.actions == null ? that.actions != null : !this.actions.equals(that.actions));
    }

    public int hashCode() {
        int result = (int)(this.version ^ this.version >>> 32);
        result = 31 * result + (this.lastChecked != null ? this.lastChecked.hashCode() : 0);
        result = 31 * result + (this.lastMetCondition != null ? this.lastMetCondition.hashCode() : 0);
        result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
        return result;
    }

    public void onCheck(boolean metCondition, DateTime timestamp) {
        this.lastChecked = timestamp;
        this.dirty = true;
        if (metCondition) {
            this.lastMetCondition = timestamp;
        }
    }

    public void onActionResult(String actionId, DateTime timestamp, Action.Result result) {
        ActionStatus status = this.actions.get(actionId);
        status.update(timestamp, result);
        this.dirty = true;
    }

    boolean onAck(DateTime timestamp, String ... actionIds) {
        boolean changed = false;
        boolean containsAll = false;
        for (String string : actionIds) {
            if (!string.equals("_all")) continue;
            containsAll = true;
            break;
        }
        if (containsAll) {
            for (ActionStatus status : this.actions.values()) {
                changed |= status.onAck(timestamp);
            }
            this.dirty |= changed;
            return changed;
        }
        for (String string : actionIds) {
            ActionStatus status = this.actions.get(string);
            if (status == null) continue;
            changed |= status.onAck(timestamp);
        }
        this.dirty |= changed;
        return changed;
    }

    boolean setActive(boolean active, DateTime now) {
        boolean change;
        boolean bl = change = this.state.active != active;
        if (change) {
            this.dirty = true;
            this.state = new State(active, now);
        }
        return change;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        WatcherDateTimeUtils.writeOptionalDate(out, this.lastChecked);
        WatcherDateTimeUtils.writeOptionalDate(out, this.lastMetCondition);
        out.writeInt(this.actions.size());
        for (Map.Entry<String, ActionStatus> entry : this.actions.entrySet()) {
            out.writeString(entry.getKey());
            ActionStatus.writeTo(entry.getValue(), out);
        }
        out.writeBoolean(this.state.active);
        WatcherDateTimeUtils.writeDate(out, this.state.timestamp);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.version = in.readLong();
        this.lastChecked = WatcherDateTimeUtils.readOptionalDate(in, DateTimeZone.UTC);
        this.lastMetCondition = WatcherDateTimeUtils.readOptionalDate(in, DateTimeZone.UTC);
        int count = in.readInt();
        HashMap<String, ActionStatus> actions = new HashMap<String, ActionStatus>(count);
        for (int i = 0; i < count; ++i) {
            actions.put(in.readString(), ActionStatus.readFrom(in));
        }
        this.actions = Collections.unmodifiableMap(actions);
        this.state = new State(in.readBoolean(), WatcherDateTimeUtils.readDate(in, DateTimeZone.UTC));
    }

    public static WatchStatus read(StreamInput in) throws IOException {
        WatchStatus status = new WatchStatus();
        status.readFrom(in);
        return status;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean(INCLUDE_VERSION_KEY, false)) {
            builder.field(Field.VERSION.getPreferredName(), this.version);
        }
        builder.field(Field.STATE.getPreferredName(), this.state, params);
        if (this.lastChecked != null) {
            builder.field(Field.LAST_CHECKED.getPreferredName(), this.lastChecked);
        }
        if (this.lastMetCondition != null) {
            builder.field(Field.LAST_MET_CONDITION.getPreferredName(), this.lastMetCondition);
        }
        if (this.actions != null) {
            builder.startObject(Field.ACTIONS.getPreferredName());
            for (Map.Entry<String, ActionStatus> entry : this.actions.entrySet()) {
                builder.field(entry.getKey(), entry.getValue(), params);
            }
            builder.endObject();
        }
        return builder.endObject();
    }

    public static WatchStatus parse(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        State state = null;
        DateTime lastChecked = null;
        DateTime lastMetCondition = null;
        Map<String, ActionStatus> actions = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Field.STATE.match(currentFieldName)) {
                try {
                    state = State.parse(parser);
                    continue;
                }
                catch (ElasticsearchParseException e) {
                    throw new ElasticsearchParseException("could not parse watch status for [{}]. failed to parse field [{}]", (Throwable)e, watchId, currentFieldName);
                }
            }
            if (Field.LAST_CHECKED.match(currentFieldName)) {
                if (token.isValue()) {
                    lastChecked = WatcherDateTimeUtils.parseDate(currentFieldName, parser, DateTimeZone.UTC);
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch status for [{}]. expecting field [{}] to hold a date value, found [{}] instead", new Object[]{watchId, currentFieldName, token});
            }
            if (Field.LAST_MET_CONDITION.match(currentFieldName)) {
                if (token.isValue()) {
                    lastMetCondition = WatcherDateTimeUtils.parseDate(currentFieldName, parser, DateTimeZone.UTC);
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch status for [{}]. expecting field [{}] to hold a date value, found [{}] instead", new Object[]{watchId, currentFieldName, token});
            }
            if (!Field.ACTIONS.match(currentFieldName)) continue;
            actions = new HashMap<String, ActionStatus>();
            if (token == XContentParser.Token.START_OBJECT) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    ActionStatus actionStatus = ActionStatus.parse(watchId, currentFieldName, parser);
                    actions.put(currentFieldName, actionStatus);
                }
                continue;
            }
            throw new ElasticsearchParseException("could not parse watch status for [{}]. expecting field [{}] to be an object, found [{}] instead", new Object[]{watchId, currentFieldName, token});
        }
        if (state == null) {
            state = new State(true, WatcherXContentParser.clock(parser).nowUTC());
        }
        actions = actions == null ? Collections.emptyMap() : Collections.unmodifiableMap(actions);
        return new WatchStatus(-1L, state, lastChecked, lastMetCondition, actions);
    }

    static interface Field {
        public static final ParseField VERSION = new ParseField("version", new String[0]);
        public static final ParseField STATE = new ParseField("state", new String[0]);
        public static final ParseField ACTIVE = new ParseField("active", new String[0]);
        public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
        public static final ParseField LAST_CHECKED = new ParseField("last_checked", new String[0]);
        public static final ParseField LAST_MET_CONDITION = new ParseField("last_met_condition", new String[0]);
        public static final ParseField ACTIONS = new ParseField("actions", new String[0]);
    }

    public static class State
    implements ToXContent {
        final boolean active;
        final DateTime timestamp;

        public State(boolean active, DateTime timestamp) {
            this.active = active;
            this.timestamp = timestamp;
        }

        public boolean isActive() {
            return this.active;
        }

        public DateTime getTimestamp() {
            return this.timestamp;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Field.ACTIVE.getPreferredName(), this.active);
            WatcherDateTimeUtils.writeDate(Field.TIMESTAMP.getPreferredName(), builder, this.timestamp);
            return builder.endObject();
        }

        public static State parse(XContentParser parser) throws IOException {
            XContentParser.Token token;
            if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("expected an object but found [{}] instead", new Object[]{parser.currentToken()});
            }
            boolean active = true;
            DateTime timestamp = SystemClock.INSTANCE.nowUTC();
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (Field.ACTIVE.match(currentFieldName)) {
                    active = parser.booleanValue();
                    continue;
                }
                if (!Field.TIMESTAMP.match(currentFieldName)) continue;
                timestamp = WatcherDateTimeUtils.parseDate(currentFieldName, parser, DateTimeZone.UTC);
            }
            return new State(active, timestamp);
        }
    }
}

