/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.trigger.schedule.CronnableSchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.Schedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.support.YearTimes;

public class YearlySchedule
extends CronnableSchedule {
    public static final String TYPE = "yearly";
    public static final YearTimes[] DEFAULT_TIMES = new YearTimes[]{new YearTimes()};
    private final YearTimes[] times;

    YearlySchedule() {
        this(DEFAULT_TIMES);
    }

    YearlySchedule(YearTimes ... times) {
        super(YearlySchedule.crons(times));
        this.times = times;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public YearTimes[] times() {
        return this.times;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (params.paramAsBoolean("normalize", false) && this.times.length == 1) {
            return this.times[0].toXContent(builder, params);
        }
        builder.startArray();
        for (YearTimes yearTimes : this.times) {
            yearTimes.toXContent(builder, params);
        }
        return builder.endArray();
    }

    public static Builder builder() {
        return new Builder();
    }

    static String[] crons(YearTimes[] times) {
        assert (times.length > 0) : "at least one time must be defined";
        HashSet<String> crons = new HashSet<String>(times.length);
        for (YearTimes time : times) {
            crons.addAll(time.crons());
        }
        return crons.toArray(new String[crons.size()]);
    }

    public static class Builder {
        private final Set<YearTimes> times = new HashSet<YearTimes>();

        private Builder() {
        }

        public Builder time(YearTimes time) {
            this.times.add(time);
            return this;
        }

        public Builder time(YearTimes.Builder builder) {
            return this.time(builder.build());
        }

        public YearlySchedule build() {
            return this.times.isEmpty() ? new YearlySchedule() : new YearlySchedule(this.times.toArray(new YearTimes[this.times.size()]));
        }
    }

    public static class Parser
    implements Schedule.Parser<YearlySchedule> {
        @Override
        public String type() {
            return YearlySchedule.TYPE;
        }

        @Override
        public YearlySchedule parse(XContentParser parser) throws IOException {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                try {
                    return new YearlySchedule(YearTimes.parse(parser, parser.currentToken()));
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("could not parse [{}] schedule. invalid year times", (Throwable)pe, YearlySchedule.TYPE);
                }
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                XContentParser.Token token;
                ArrayList<YearTimes> times = new ArrayList<YearTimes>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    try {
                        times.add(YearTimes.parse(parser, token));
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse [{}] schedule. invalid year times", (Throwable)pe, YearlySchedule.TYPE);
                    }
                }
                return times.isEmpty() ? new YearlySchedule() : new YearlySchedule(times.toArray(new YearTimes[times.size()]));
            }
            throw new ElasticsearchParseException("could not parse [{}] schedule. expected either an object or an array of objects representing year times, but found [{}] instead", new Object[]{YearlySchedule.TYPE, parser.currentToken()});
        }
    }
}

