/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.put;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.watcher.WatcherService;
import org.elasticsearch.xpack.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.xpack.watcher.transport.actions.put.PutWatchRequest;
import org.elasticsearch.xpack.watcher.transport.actions.put.PutWatchResponse;

public class TransportPutWatchAction
extends WatcherTransportAction<PutWatchRequest, PutWatchResponse> {
    private final WatcherService watcherService;

    @Inject
    public TransportPutWatchAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, WatcherService watcherService, XPackLicenseState licenseState) {
        super(settings, "cluster:admin/xpack/watcher/watch/put", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, licenseState, PutWatchRequest::new);
        this.watcherService = watcherService;
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected PutWatchResponse newResponse() {
        return new PutWatchResponse();
    }

    @Override
    protected void masterOperation(PutWatchRequest request, ClusterState state, ActionListener<PutWatchResponse> listener) throws ElasticsearchException {
        if (!this.licenseState.isWatcherAllowed()) {
            listener.onFailure(LicenseUtils.newComplianceException("watcher"));
            return;
        }
        try {
            IndexResponse indexResponse = this.watcherService.putWatch(request.getId(), request.getSource(), request.xContentType(), request.isActive());
            boolean created = indexResponse.getResult() == DocWriteResponse.Result.CREATED;
            listener.onResponse(new PutWatchResponse(indexResponse.getId(), indexResponse.getVersion(), created));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Override
    protected ClusterBlockException checkBlock(PutWatchRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, ".watches");
    }
}

