/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transform.script;

import java.io.IOException;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptSettings;
import org.elasticsearch.xpack.watcher.transform.TransformFactory;
import org.elasticsearch.xpack.watcher.transform.script.ExecutableScriptTransform;
import org.elasticsearch.xpack.watcher.transform.script.ScriptTransform;

public class ScriptTransformFactory
extends TransformFactory<ScriptTransform, ScriptTransform.Result, ExecutableScriptTransform> {
    private final ScriptService scriptService;
    private final Settings settings;

    public ScriptTransformFactory(Settings settings, ScriptService scriptService) {
        super(Loggers.getLogger(ExecutableScriptTransform.class, settings, new String[0]));
        this.settings = settings;
        this.scriptService = scriptService;
    }

    @Override
    public String type() {
        return "script";
    }

    @Override
    public ScriptTransform parseTransform(String watchId, XContentParser parser, boolean upgradeTransformSource) throws IOException {
        String defaultLegacyScriptLanguage = ScriptSettings.getLegacyDefaultLang(this.settings);
        return ScriptTransform.parse(watchId, parser, upgradeTransformSource, defaultLegacyScriptLanguage);
    }

    @Override
    public ExecutableScriptTransform createExecutable(ScriptTransform transform) {
        return new ExecutableScriptTransform(transform, this.transformLogger, this.scriptService);
    }
}

