/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support.xcontent;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Strings;

public class ObjectPath {
    private ObjectPath() {
    }

    public static <T> T eval(String path, Object object) {
        return (T)ObjectPath.evalContext(path, object);
    }

    private static Object evalContext(String path, Object ctx) {
        String[] parts = path == null || path.isEmpty() ? Strings.EMPTY_ARRAY : path.split("\\.");
        StringBuilder resolved = new StringBuilder();
        for (String part : parts) {
            int index;
            if (ctx == null) {
                return null;
            }
            if (ctx instanceof Map) {
                ctx = ((Map)ctx).get(part);
                if (resolved.length() != 0) {
                    resolved.append(".");
                }
                resolved.append(part);
                continue;
            }
            if (ctx instanceof List) {
                try {
                    index = Integer.parseInt(part);
                    ctx = ((List)ctx).get(index);
                    if (resolved.length() != 0) {
                        resolved.append(".");
                    }
                    resolved.append(part);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            if (ctx.getClass().isArray()) {
                try {
                    index = Integer.parseInt(part);
                    ctx = Array.get(ctx, index);
                    if (resolved.length() != 0) {
                        resolved.append(".");
                    }
                    resolved.append(part);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            return null;
        }
        return ctx;
    }
}

