/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.watcher.client.WatcherClient;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;
import org.elasticsearch.xpack.watcher.transport.actions.stats.WatcherStatsRequest;
import org.elasticsearch.xpack.watcher.transport.actions.stats.WatcherStatsResponse;

public class RestWatcherStatsAction
extends WatcherRestHandler {
    public RestWatcherStatsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, URI_BASE + "/stats", this, RestRequest.Method.GET, "/_watcher/stats", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, URI_BASE + "/stats/{metric}", this, RestRequest.Method.GET, "/_watcher/stats/{metric}", this.deprecationLogger);
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(final RestRequest restRequest, WatcherClient client) throws IOException {
        Set<String> metrics = Strings.splitStringByCommaToSet(restRequest.param("metric", ""));
        WatcherStatsRequest request = new WatcherStatsRequest();
        if (metrics.contains("_all")) {
            request.includeCurrentWatches(true);
            request.includeQueuedWatches(true);
        } else {
            request.includeCurrentWatches(metrics.contains("queued_watches"));
            request.includeQueuedWatches(metrics.contains("pending_watches"));
        }
        return channel -> client.watcherStats(request, (ActionListener<WatcherStatsResponse>)new RestBuilderListener<WatcherStatsResponse>(channel){

            @Override
            public RestResponse buildResponse(WatcherStatsResponse watcherStatsResponse, XContentBuilder builder) throws Exception {
                watcherStatsResponse.toXContent(builder, restRequest);
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

