/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.chain;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.input.ExecutableInput;
import org.elasticsearch.xpack.watcher.input.Input;
import org.elasticsearch.xpack.watcher.input.InputFactory;
import org.elasticsearch.xpack.watcher.input.InputRegistry;
import org.elasticsearch.xpack.watcher.input.chain.ChainInput;
import org.elasticsearch.xpack.watcher.input.chain.ExecutableChainInput;

public class ChainInputFactory
extends InputFactory<ChainInput, ChainInput.Result, ExecutableChainInput> {
    private final InputRegistry inputRegistry;

    @Inject
    public ChainInputFactory(Settings settings, InputRegistry inputRegistry) {
        super(Loggers.getLogger(ExecutableChainInput.class, settings, new String[0]));
        this.inputRegistry = inputRegistry;
    }

    @Override
    public String type() {
        return "chain";
    }

    @Override
    public ChainInput parseInput(String watchId, XContentParser parser, boolean upgradeInputSource) throws IOException {
        return ChainInput.parse(watchId, parser, this.inputRegistry);
    }

    @Override
    public ExecutableChainInput createExecutable(ChainInput input) {
        ArrayList<Tuple<String, ExecutableInput>> executableInputs = new ArrayList<Tuple<String, ExecutableInput>>();
        for (Tuple<String, Input> tuple : input.getInputs()) {
            Object executableInput = this.inputRegistry.factories().get(tuple.v2().type()).createExecutable(tuple.v2());
            executableInputs.add(new Tuple(tuple.v1(), executableInput));
        }
        return new ExecutableChainInput(input, executableInputs, this.inputLogger);
    }
}

