/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.xpack.common.http.HttpRequestTemplate;
import org.elasticsearch.xpack.watcher.input.chain.ChainInput;
import org.elasticsearch.xpack.watcher.input.http.HttpInput;
import org.elasticsearch.xpack.watcher.input.none.NoneInput;
import org.elasticsearch.xpack.watcher.input.search.SearchInput;
import org.elasticsearch.xpack.watcher.input.simple.SimpleInput;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateRequest;
import org.elasticsearch.xpack.watcher.watch.Payload;

public final class InputBuilders {
    private InputBuilders() {
    }

    public static NoneInput.Builder noneInput() {
        return NoneInput.builder();
    }

    public static SearchInput.Builder searchInput(WatcherSearchTemplateRequest request) {
        return SearchInput.builder(request);
    }

    public static SimpleInput.Builder simpleInput() {
        return InputBuilders.simpleInput(new HashMap<String, Object>());
    }

    public static SimpleInput.Builder simpleInput(String key, Object value) {
        return InputBuilders.simpleInput(MapBuilder.newMapBuilder().put(key, value));
    }

    public static SimpleInput.Builder simpleInput(MapBuilder<String, Object> data) {
        return InputBuilders.simpleInput(data.map());
    }

    public static SimpleInput.Builder simpleInput(Map<String, Object> data) {
        return SimpleInput.builder(new Payload.Simple(data));
    }

    public static HttpInput.Builder httpInput(HttpRequestTemplate.Builder request) {
        return InputBuilders.httpInput(request.build());
    }

    public static HttpInput.Builder httpInput(HttpRequestTemplate request) {
        return HttpInput.builder(request);
    }

    public static ChainInput.Builder chainInput() {
        return ChainInput.builder();
    }
}

