/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.condition;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.condition.Condition;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;

public final class AlwaysCondition
extends Condition {
    public static final String TYPE = "always";
    public static final Condition.Result RESULT_INSTANCE = new Condition.Result(null, "always", true);
    public static final Condition INSTANCE = new AlwaysCondition();

    private AlwaysCondition() {
        super(TYPE);
    }

    public static Condition parse(String watchId, XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("unable to parse [{}] condition for watch [{}]. expected an empty object but found [{}]", TYPE, watchId, parser.currentName());
        }
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("unable to parse [{}] condition for watch [{}]. expected an empty object but found [{}]", TYPE, watchId, parser.currentName());
        }
        return INSTANCE;
    }

    @Override
    public Condition.Result execute(WatchExecutionContext ctx) {
        return RESULT_INSTANCE;
    }

    public boolean equals(Object obj) {
        return obj instanceof AlwaysCondition;
    }

    public int hashCode() {
        return 0;
    }
}

